/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mainwindow;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.extras.FlatAnimatedLafChange;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.StyleContext;
import mediathek.gui.messages.FontSizeChangedEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.jetbrains.annotations.NotNull;

public class FontManager {
    private static final String KEY_DEFAULT_FONT = "defaultFont";
    private static final String KEY_LABEL_FONT = "Label.font";
    private static final String CONFIG_DEFAULT_FONT_SIZE = "ui.default_font.size";
    private static final String CONFIG_DEFAULT_FONT_FAMILY = "ui.default_font.family";
    private final String[] availableFontFamilyNames;
    private final JMenu fontMenu;
    private final JMenuItem restoreFontMenuItem = new JMenuItem();
    private final JMenuItem incrFontMenuItem = new JMenuItem();
    private final JMenuItem decrFontMenuItem = new JMenuItem();

    public FontManager(@NotNull JMenu fontMenu) {
        this.fontMenu = fontMenu;
        this.availableFontFamilyNames = (String[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames().clone();
        Arrays.sort(this.availableFontFamilyNames);
        this.initStandardMenuEntries();
        this.createStandardMenuEntries();
        this.updateFontMenuItems();
    }

    private void initStandardMenuEntries() {
        this.restoreFontMenuItem.setText("Schrift zur\u00fccksetzen");
        this.restoreFontMenuItem.setAccelerator(KeyStroke.getKeyStroke(48, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.restoreFontMenuItem.addActionListener(e -> this.resetFont());
        this.incrFontMenuItem.setText("Schrift vergr\u00f6\u00dfern");
        this.incrFontMenuItem.setAccelerator(KeyStroke.getKeyStroke(521, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.incrFontMenuItem.addActionListener(e -> this.increaseFontSize());
        this.decrFontMenuItem.setText("Schrift verkleinern");
        this.decrFontMenuItem.setAccelerator(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.decrFontMenuItem.addActionListener(e -> this.decreaseFontSize());
    }

    private void createStandardMenuEntries() {
        this.fontMenu.add(this.restoreFontMenuItem);
        this.fontMenu.add(this.incrFontMenuItem);
        this.fontMenu.add(this.decrFontMenuItem);
    }

    private void resetFont() {
        FlatAnimatedLafChange.showSnapshot();
        UIManager.put(KEY_DEFAULT_FONT, null);
        this.updateFontMenuItems();
        FlatLaf.updateUI();
        FlatAnimatedLafChange.hideSnapshotWithAnimation();
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.WRITE);
            config.clearProperty(CONFIG_DEFAULT_FONT_SIZE);
            config.clearProperty(CONFIG_DEFAULT_FONT_FAMILY);
        }
        finally {
            config.unlock(LockMode.WRITE);
        }
        MessageBus.getMessageBus().publishAsync((Object)new FontSizeChangedEvent());
    }

    private void increaseFontSize() {
        FlatAnimatedLafChange.showSnapshot();
        Font font = UIManager.getFont(KEY_DEFAULT_FONT);
        float newFontSize = font.getSize() + 1;
        Font newFont = font.deriveFont(newFontSize);
        UIManager.put(KEY_DEFAULT_FONT, newFont);
        this.updateFontMenuItems();
        FlatLaf.updateUI();
        FlatAnimatedLafChange.hideSnapshotWithAnimation();
        this.writeConfigData();
        MessageBus.getMessageBus().publishAsync((Object)new FontSizeChangedEvent());
    }

    private void decreaseFontSize() {
        FlatAnimatedLafChange.showSnapshot();
        Font font = UIManager.getFont(KEY_DEFAULT_FONT);
        float newFontSize = Math.max(font.getSize() - 1, 10);
        Font newFont = font.deriveFont(newFontSize);
        UIManager.put(KEY_DEFAULT_FONT, newFont);
        this.updateFontMenuItems();
        FlatLaf.updateUI();
        FlatAnimatedLafChange.hideSnapshotWithAnimation();
        this.writeConfigData();
        MessageBus.getMessageBus().publishAsync((Object)new FontSizeChangedEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfigData() {
        Font currentFont = UIManager.getFont(KEY_LABEL_FONT);
        String currentFamily = currentFont.getFamily();
        int currentSize = currentFont.getSize();
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.WRITE);
            config.setProperty(CONFIG_DEFAULT_FONT_FAMILY, (Object)currentFamily);
            config.setProperty(CONFIG_DEFAULT_FONT_SIZE, (Object)currentSize);
        }
        finally {
            config.unlock(LockMode.WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreConfigData() {
        FlatAnimatedLafChange.showSnapshot();
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.READ);
            String currentFamily = config.getString(CONFIG_DEFAULT_FONT_FAMILY);
            int currentSize = config.getInt(CONFIG_DEFAULT_FONT_SIZE);
            Font font = UIManager.getFont(KEY_DEFAULT_FONT);
            Font newFont = StyleContext.getDefaultStyleContext().getFont(currentFamily, font.getStyle(), currentSize);
            newFont = FlatUIUtils.nonUIResource((Font)newFont);
            UIManager.put(KEY_DEFAULT_FONT, newFont);
        }
        catch (Exception exception) {
        }
        finally {
            config.unlock(LockMode.READ);
        }
        FlatLaf.updateUI();
        FlatAnimatedLafChange.hideSnapshotWithAnimation();
        this.updateFontMenuItems();
    }

    private void updateFontMenuItems() {
        this.fontMenu.removeAll();
        this.createStandardMenuEntries();
        this.fontMenu.addSeparator();
        Font currentFont = UIManager.getFont(KEY_LABEL_FONT);
        String currentFamily = currentFont.getFamily();
        String currentSize = Integer.toString(currentFont.getSize());
        ArrayList<String> families = new ArrayList<String>(Arrays.asList("Arial", "Cantarell", "Comic Sans MS", "DejaVu Sans", "Dialog", "Liberation Sans", "Noto Sans", "Roboto", "SansSerif", "Segoe UI", "Serif", "Tahoma", "Ubuntu", "Verdana"));
        if (!families.contains(currentFamily)) {
            families.add(currentFamily);
        }
        families.sort(String.CASE_INSENSITIVE_ORDER);
        ButtonGroup familiesGroup = new ButtonGroup();
        for (String family : families) {
            if (Arrays.binarySearch(this.availableFontFamilyNames, family) < 0) continue;
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(family);
            item.setSelected(family.equals(currentFamily));
            item.addActionListener(this::fontFamilyChanged);
            this.fontMenu.add(item);
            familiesGroup.add(item);
        }
        this.fontMenu.addSeparator();
        ArrayList<String> sizes = new ArrayList<String>(Arrays.asList("10", "11", "12", "13", "14", "16", "18", "20", "24", "28"));
        if (!sizes.contains(currentSize)) {
            sizes.add(currentSize);
        }
        sizes.sort(String.CASE_INSENSITIVE_ORDER);
        ButtonGroup sizesGroup = new ButtonGroup();
        for (String size : sizes) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(size);
            item.setSelected(size.equals(currentSize));
            item.addActionListener(this::fontSizeChanged);
            this.fontMenu.add(item);
            sizesGroup.add(item);
        }
        boolean enabled = UIManager.getLookAndFeel() instanceof FlatLaf;
        for (Component item : this.fontMenu.getMenuComponents()) {
            item.setEnabled(enabled);
        }
    }

    private void fontFamilyChanged(ActionEvent e) {
        String fontFamily = e.getActionCommand();
        FlatAnimatedLafChange.showSnapshot();
        Font font = UIManager.getFont(KEY_DEFAULT_FONT);
        Font newFont = StyleContext.getDefaultStyleContext().getFont(fontFamily, font.getStyle(), font.getSize());
        newFont = FlatUIUtils.nonUIResource((Font)newFont);
        UIManager.put(KEY_DEFAULT_FONT, newFont);
        FlatLaf.updateUI();
        FlatAnimatedLafChange.hideSnapshotWithAnimation();
        this.writeConfigData();
        MessageBus.getMessageBus().publishAsync((Object)new FontSizeChangedEvent());
    }

    private void fontSizeChanged(ActionEvent e) {
        String fontSizeStr = e.getActionCommand();
        FlatAnimatedLafChange.showSnapshot();
        Font font = UIManager.getFont(KEY_DEFAULT_FONT);
        Font newFont = font.deriveFont((float)Integer.parseInt(fontSizeStr));
        UIManager.put(KEY_DEFAULT_FONT, newFont);
        FlatLaf.updateUI();
        FlatAnimatedLafChange.hideSnapshotWithAnimation();
        this.writeConfigData();
        MessageBus.getMessageBus().publishAsync((Object)new FontSizeChangedEvent());
    }
}

