/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.hash;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.credential.hash.Salt;
import org.keycloak.crypto.hash.Argon2Parameters;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.models.credential.dto.PasswordCredentialData;
import org.keycloak.models.credential.dto.PasswordSecretData;
import org.keycloak.tracing.TracingProvider;
import org.keycloak.tracing.TracingProviderUtil;

public class Argon2PasswordHashProvider
implements PasswordHashProvider {
    private static final Logger logger = Logger.getLogger(Argon2PasswordHashProvider.class);
    private final String version;
    private final String type;
    private final int hashLength;
    private final int memory;
    private final int iterations;
    private final int parallelism;
    private final Semaphore cpuCoreSemaphore;

    public Argon2PasswordHashProvider(String version, String type, int hashLength, int memory, int iterations, int parallelism, Semaphore cpuCoreSemaphore) {
        this.version = version;
        this.type = type;
        this.hashLength = hashLength;
        this.memory = memory;
        this.iterations = iterations;
        this.parallelism = parallelism;
        this.cpuCoreSemaphore = cpuCoreSemaphore;
    }

    public boolean policyCheck(PasswordPolicy policy, PasswordCredentialModel credential) {
        PasswordCredentialData data = credential.getPasswordCredentialData();
        return this.iterations == data.getHashIterations() && this.checkCredData("type", this.type, data) && this.checkCredData("version", this.version, data) && this.checkCredData("hashLength", this.hashLength, data) && this.checkCredData("memory", this.memory, data) && this.checkCredData("parallelism", this.parallelism, data);
    }

    public PasswordCredentialModel encodedCredential(String rawPassword, int iterations) {
        if (iterations == -1) {
            iterations = this.iterations;
        } else if (iterations > 100) {
            logger.warn((Object)"Iterations for Argon should be less than 100, using default");
            iterations = this.iterations;
        }
        byte[] salt = Salt.generateSalt();
        String encoded = this.encode(rawPassword, salt, this.version, this.type, this.hashLength, this.parallelism, this.memory, iterations);
        HashMap<String, List<String>> additionalParameters = new HashMap<String, List<String>>();
        additionalParameters.put("version", Collections.singletonList(this.version));
        additionalParameters.put("type", Collections.singletonList(this.type));
        additionalParameters.put("hashLength", Collections.singletonList(Integer.toString(this.hashLength)));
        additionalParameters.put("memory", Collections.singletonList(Integer.toString(this.memory)));
        additionalParameters.put("parallelism", Collections.singletonList(Integer.toString(this.parallelism)));
        return PasswordCredentialModel.createFromValues((String)"argon2", (byte[])salt, (int)iterations, additionalParameters, (String)encoded);
    }

    public boolean verify(String rawPassword, PasswordCredentialModel credential) {
        PasswordCredentialData data = credential.getPasswordCredentialData();
        MultivaluedHashMap parameters = data.getAdditionalParameters();
        PasswordSecretData secretData = credential.getPasswordSecretData();
        String version = (String)parameters.getFirst((Object)"version");
        String type = (String)parameters.getFirst((Object)"type");
        int hashLength = Integer.parseInt((String)parameters.getFirst((Object)"hashLength"));
        int parallelism = Integer.parseInt((String)parameters.getFirst((Object)"parallelism"));
        int memory = Integer.parseInt((String)parameters.getFirst((Object)"memory"));
        int iterations = data.getHashIterations();
        String encoded = this.encode(rawPassword, secretData.getSalt(), version, type, hashLength, parallelism, memory, iterations);
        return encoded.equals(secretData.getValue());
    }

    public String credentialHashingStrength(PasswordCredentialModel credential) {
        MultivaluedHashMap parameters = credential.getPasswordCredentialData().getAdditionalParameters();
        return String.format("Argon2%s-%s[m=%s,t=%d,p=%s]", parameters.getFirst((Object)"type"), parameters.getFirst((Object)"version"), parameters.getFirst((Object)"memory"), credential.getPasswordCredentialData().getHashIterations(), parameters.getFirst((Object)"parallelism"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String encode(String rawPassword, byte[] salt, String version, String type, int hashLength, int parallelism, int memory, int iterations) {
        TracingProvider tracing = TracingProviderUtil.getTracingProvider();
        try {
            String string = (String)tracing.trace(Argon2PasswordHashProvider.class, "encode", span -> {
                try {
                    this.cpuCoreSemaphore.acquire();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                org.bouncycastle.crypto.params.Argon2Parameters parameters = new Argon2Parameters.Builder(Argon2Parameters.getTypeValue(type)).withVersion(Argon2Parameters.getVersionValue(version)).withSalt(salt).withParallelism(parallelism).withMemoryAsKB(memory).withIterations(iterations).build();
                Argon2BytesGenerator generator = new Argon2BytesGenerator();
                generator.init(parameters);
                byte[] result = new byte[hashLength];
                generator.generateBytes(rawPassword.toCharArray(), result);
                return Base64.encodeBytes((byte[])result);
            });
            return string;
        }
        finally {
            this.cpuCoreSemaphore.release();
        }
    }

    private boolean checkCredData(String key, int expectedValue, PasswordCredentialData data) {
        String s = (String)data.getAdditionalParameters().getFirst((Object)key);
        Integer v = s != null ? Integer.valueOf(Integer.parseInt(s)) : null;
        return v != null && expectedValue == v;
    }

    private boolean checkCredData(String key, String expectedValue, PasswordCredentialData data) {
        String s = (String)data.getAdditionalParameters().getFirst((Object)key);
        return expectedValue.equals(s);
    }

    public void close() {
    }
}

