/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.configuration.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.keycloak.storage.configuration.ServerConfigStorageProvider;
import org.keycloak.storage.configuration.jpa.entity.ServerConfigEntity;

public class JpaServerConfigStorageProvider
implements ServerConfigStorageProvider {
    private final EntityManager entityManager;

    public JpaServerConfigStorageProvider(EntityManager entityManager) {
        this.entityManager = Objects.requireNonNull(entityManager);
    }

    public Optional<String> find(String key) {
        return Optional.ofNullable(this.getEntity(key)).map(ServerConfigEntity::getValue);
    }

    public void store(String key, String value) {
        ServerConfigEntity entity = this.getEntity(key);
        if (entity == null) {
            entity = new ServerConfigEntity();
            entity.setKey(Objects.requireNonNull(key));
            entity.setValue(Objects.requireNonNull(value));
            this.entityManager.persist((Object)entity);
            return;
        }
        entity.setValue(Objects.requireNonNull(value));
        this.entityManager.merge((Object)entity);
    }

    public void remove(String key) {
        ServerConfigEntity entity = this.getEntity(key);
        if (entity != null) {
            this.entityManager.remove((Object)entity);
        }
    }

    public String loadOrCreate(String key, Supplier<String> valueGenerator) {
        ServerConfigEntity entity = this.getEntity(key);
        if (entity != null) {
            return entity.getValue();
        }
        String value = Objects.requireNonNull(valueGenerator.get());
        entity = new ServerConfigEntity();
        entity.setKey(Objects.requireNonNull(key));
        entity.setValue(value);
        this.entityManager.persist((Object)entity);
        return value;
    }

    public boolean replace(String key, Predicate<String> replacePredicate, Supplier<String> valueGenerator) {
        Objects.requireNonNull(replacePredicate);
        Objects.requireNonNull(valueGenerator);
        ServerConfigEntity entity = this.getEntity(key);
        if (entity == null || !replacePredicate.test(entity.getValue())) {
            return false;
        }
        entity.setValue(valueGenerator.get());
        this.entityManager.merge((Object)entity);
        return true;
    }

    public void close() {
    }

    private ServerConfigEntity getEntity(String key) {
        return (ServerConfigEntity)this.entityManager.find(ServerConfigEntity.class, (Object)Objects.requireNonNull(key), LockModeType.OPTIMISTIC);
    }
}

