/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public class RC2ParameterSpec
implements AlgorithmParameterSpec {
    private byte[] iv = null;
    private int effectiveKeyBits;

    public RC2ParameterSpec(int n) {
        this.effectiveKeyBits = n;
    }

    public RC2ParameterSpec(int n, byte[] byArray) {
        this(n, byArray, 0);
    }

    public RC2ParameterSpec(int n, byte[] byArray, int n2) {
        this.effectiveKeyBits = n;
        if (byArray == null) {
            throw new IllegalArgumentException("IV missing");
        }
        int n3 = 8;
        if (byArray.length - n2 < n3) {
            throw new IllegalArgumentException("IV too short");
        }
        this.iv = new byte[n3];
        System.arraycopy(byArray, n2, this.iv, 0, n3);
    }

    public int getEffectiveKeyBits() {
        return this.effectiveKeyBits;
    }

    public byte[] getIV() {
        return this.iv == null ? null : (byte[])this.iv.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RC2ParameterSpec)) {
            return false;
        }
        RC2ParameterSpec rC2ParameterSpec = (RC2ParameterSpec)object;
        return this.effectiveKeyBits == rC2ParameterSpec.effectiveKeyBits && Arrays.equals(this.iv, rC2ParameterSpec.iv);
    }

    public int hashCode() {
        int n = 0;
        if (this.iv != null) {
            for (int i = 1; i < this.iv.length; ++i) {
                n += this.iv[i] * i;
            }
        }
        return n += this.effectiveKeyBits;
    }
}

