/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene912;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.lucene912.ForDeltaUtil;
import org.apache.lucene.codecs.lucene912.ForUtil;
import org.apache.lucene.codecs.lucene912.Lucene912PostingsFormat;
import org.apache.lucene.codecs.lucene912.PForUtil;
import org.apache.lucene.codecs.lucene912.PostingsUtil;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Impact;
import org.apache.lucene.index.Impacts;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SlowImpactsEnum;
import org.apache.lucene.internal.vectorization.PostingDecodingUtil;
import org.apache.lucene.internal.vectorization.VectorizationProvider;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;

public final class Lucene912PostingsReader
extends PostingsReaderBase {
    static final VectorizationProvider VECTORIZATION_PROVIDER = VectorizationProvider.getInstance();
    private final IndexInput docIn;
    private final IndexInput posIn;
    private final IndexInput payIn;
    private final int maxNumImpactsAtLevel0;
    private final int maxImpactNumBytesAtLevel0;
    private final int maxNumImpactsAtLevel1;
    private final int maxImpactNumBytesAtLevel1;
    private final int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene912PostingsReader(SegmentReadState state) throws IOException {
        long expectedPayFileLength;
        long expectedPosFileLength;
        long expectedDocFileLength;
        boolean success;
        block13: {
            ChecksumIndexInput metaIn;
            block12: {
                String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "psm");
                metaIn = null;
                success = false;
                try {
                    metaIn = state.directory.openChecksumInput(metaName, IOContext.READONCE);
                    this.version = CodecUtil.checkIndexHeader(metaIn, "Lucene912PostingsWriterMeta", 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.maxNumImpactsAtLevel0 = metaIn.readInt();
                    this.maxImpactNumBytesAtLevel0 = metaIn.readInt();
                    this.maxNumImpactsAtLevel1 = metaIn.readInt();
                    this.maxImpactNumBytesAtLevel1 = metaIn.readInt();
                    expectedDocFileLength = metaIn.readLong();
                    if (state.fieldInfos.hasProx()) {
                        expectedPosFileLength = metaIn.readLong();
                        expectedPayFileLength = state.fieldInfos.hasPayloads() || state.fieldInfos.hasOffsets() ? metaIn.readLong() : -1L;
                    } else {
                        expectedPosFileLength = -1L;
                        expectedPayFileLength = -1L;
                    }
                    CodecUtil.checkFooter(metaIn, null);
                    success = true;
                    if (!success) break block12;
                }
                catch (Throwable t) {
                    try {
                        if (metaIn == null) throw t;
                        CodecUtil.checkFooter(metaIn, t);
                        throw new AssertionError((Object)"unreachable");
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            metaIn.close();
                            throw throwable;
                        } else {
                            IOUtils.closeWhileHandlingException(metaIn);
                        }
                        throw throwable;
                    }
                }
                metaIn.close();
                break block13;
            }
            IOUtils.closeWhileHandlingException(metaIn);
        }
        success = false;
        IndexInput docIn = null;
        IndexInput posIn = null;
        IndexInput payIn = null;
        String docName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "doc");
        try {
            docIn = state.directory.openInput(docName, state.context);
            CodecUtil.checkIndexHeader(docIn, "Lucene912PostingsWriterDoc", this.version, this.version, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.retrieveChecksum(docIn, expectedDocFileLength);
            if (state.fieldInfos.hasProx()) {
                String proxName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "pos");
                posIn = state.directory.openInput(proxName, state.context);
                CodecUtil.checkIndexHeader(posIn, "Lucene912PostingsWriterPos", this.version, this.version, state.segmentInfo.getId(), state.segmentSuffix);
                CodecUtil.retrieveChecksum(posIn, expectedPosFileLength);
                if (state.fieldInfos.hasPayloads() || state.fieldInfos.hasOffsets()) {
                    String payName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "pay");
                    payIn = state.directory.openInput(payName, state.context);
                    CodecUtil.checkIndexHeader(payIn, "Lucene912PostingsWriterPay", this.version, this.version, state.segmentInfo.getId(), state.segmentSuffix);
                    CodecUtil.retrieveChecksum(payIn, expectedPayFileLength);
                }
            }
            this.docIn = docIn;
            this.posIn = posIn;
            this.payIn = payIn;
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(docIn, posIn, payIn);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(docIn, posIn, payIn);
    }

    @Override
    public void init(IndexInput termsIn, SegmentReadState state) throws IOException {
        CodecUtil.checkIndexHeader(termsIn, "Lucene90PostingsWriterTerms", 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
        int indexBlockSize = termsIn.readVInt();
        if (indexBlockSize != 128) {
            throw new IllegalStateException("index-time BLOCK_SIZE (" + indexBlockSize + ") != read-time BLOCK_SIZE (128)");
        }
    }

    static void prefixSum(long[] buffer, int count, long base) {
        buffer[0] = buffer[0] + base;
        for (int i = 1; i < count; ++i) {
            int n = i;
            buffer[n] = buffer[n] + buffer[i - 1];
        }
    }

    static int findFirstGreater(long[] buffer, int target, int from) {
        for (int i = from; i < 128; ++i) {
            if (buffer[i] < (long)target) continue;
            return i;
        }
        return 128;
    }

    @Override
    public BlockTermState newTermState() {
        return new Lucene912PostingsFormat.IntBlockTermState();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.docIn, this.posIn, this.payIn);
    }

    @Override
    public void decodeTerm(DataInput in, FieldInfo fieldInfo, BlockTermState _termState, boolean absolute) throws IOException {
        long l;
        Lucene912PostingsFormat.IntBlockTermState termState = (Lucene912PostingsFormat.IntBlockTermState)_termState;
        boolean fieldHasPositions = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        boolean fieldHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        boolean fieldHasPayloads = fieldInfo.hasPayloads();
        if (absolute) {
            termState.docStartFP = 0L;
            termState.posStartFP = 0L;
            termState.payStartFP = 0L;
        }
        if (((l = in.readVLong()) & 1L) == 0L) {
            termState.docStartFP += l >>> 1;
            termState.singletonDocID = termState.docFreq == 1 ? in.readVInt() : -1;
        } else {
            assert (!absolute);
            assert (termState.singletonDocID != -1);
            termState.singletonDocID = (int)((long)termState.singletonDocID + BitUtil.zigZagDecode(l >>> 1));
        }
        if (fieldHasPositions) {
            termState.posStartFP += in.readVLong();
            if (fieldHasOffsets || fieldHasPayloads) {
                termState.payStartFP += in.readVLong();
            }
            termState.lastPosBlockOffset = termState.totalTermFreq > 128L ? in.readVLong() : -1L;
        }
    }

    @Override
    public PostingsEnum postings(FieldInfo fieldInfo, BlockTermState termState, PostingsEnum reuse, int flags) throws IOException {
        EverythingEnum everythingEnum;
        boolean indexHasPositions;
        boolean bl = indexHasPositions = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        if (!indexHasPositions || !PostingsEnum.featureRequested(flags, (short)24)) {
            BlockDocsEnum docsEnum;
            if (reuse instanceof BlockDocsEnum) {
                docsEnum = (BlockDocsEnum)reuse;
                if (!docsEnum.canReuse(this.docIn, fieldInfo)) {
                    docsEnum = new BlockDocsEnum(fieldInfo);
                }
            } else {
                docsEnum = new BlockDocsEnum(fieldInfo);
            }
            return docsEnum.reset((Lucene912PostingsFormat.IntBlockTermState)termState, flags);
        }
        if (reuse instanceof EverythingEnum) {
            everythingEnum = (EverythingEnum)reuse;
            if (!everythingEnum.canReuse(this.docIn, fieldInfo)) {
                everythingEnum = new EverythingEnum(fieldInfo);
            }
        } else {
            everythingEnum = new EverythingEnum(fieldInfo);
        }
        return everythingEnum.reset((Lucene912PostingsFormat.IntBlockTermState)termState, flags);
    }

    @Override
    public ImpactsEnum impacts(FieldInfo fieldInfo, BlockTermState state, int flags) throws IOException {
        boolean indexHasPositions;
        boolean indexHasFreqs = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
        boolean bl = indexHasPositions = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        if (!(state.docFreq < 128 || !indexHasFreqs || indexHasPositions && PostingsEnum.featureRequested(flags, (short)24))) {
            return new BlockImpactsDocsEnum(fieldInfo, (Lucene912PostingsFormat.IntBlockTermState)state);
        }
        boolean indexHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        boolean indexHasPayloads = fieldInfo.hasPayloads();
        if (!(state.docFreq < 128 || !indexHasPositions || indexHasOffsets && PostingsEnum.featureRequested(flags, (short)56) || indexHasPayloads && PostingsEnum.featureRequested(flags, (short)88))) {
            return new BlockImpactsPostingsEnum(fieldInfo, (Lucene912PostingsFormat.IntBlockTermState)state);
        }
        return new SlowImpactsEnum(this.postings(fieldInfo, state, null, flags));
    }

    static int readVInt15(DataInput in) throws IOException {
        short s = in.readShort();
        if (s >= 0) {
            return s;
        }
        return s & Short.MAX_VALUE | in.readVInt() << 15;
    }

    static long readVLong15(DataInput in) throws IOException {
        short s = in.readShort();
        if (s >= 0) {
            return s;
        }
        return (long)s & 0x7FFFL | in.readVLong() << 15;
    }

    static MutableImpactList readImpacts(ByteArrayDataInput in, MutableImpactList reuse) {
        int freq = 0;
        long norm = 0L;
        int length = 0;
        while (in.getPosition() < in.length()) {
            int freqDelta = in.readVInt();
            if ((freqDelta & 1) != 0) {
                freq += 1 + (freqDelta >>> 1);
                try {
                    norm += 1L + in.readZLong();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                freq += 1 + (freqDelta >>> 1);
            }
            Impact impact = reuse.impacts[length];
            impact.freq = freq;
            impact.norm = ++norm;
            ++length;
        }
        reuse.length = length;
        return reuse;
    }

    @Override
    public void checkIntegrity() throws IOException {
        if (this.docIn != null) {
            CodecUtil.checksumEntireFile(this.docIn);
        }
        if (this.posIn != null) {
            CodecUtil.checksumEntireFile(this.posIn);
        }
        if (this.payIn != null) {
            CodecUtil.checksumEntireFile(this.payIn);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(positions=" + (this.posIn != null) + ",payloads=" + (this.payIn != null) + ")";
    }

    static class MutableImpactList
    extends AbstractList<Impact>
    implements RandomAccess {
        int length;
        final Impact[] impacts;

        MutableImpactList(int capacity) {
            this.impacts = new Impact[capacity];
            for (int i = 0; i < capacity; ++i) {
                this.impacts[i] = new Impact(Integer.MAX_VALUE, 1L);
            }
        }

        @Override
        public Impact get(int index) {
            return this.impacts[index];
        }

        @Override
        public int size() {
            return this.length;
        }
    }

    final class BlockImpactsPostingsEnum
    extends ImpactsEnum {
        final ForUtil forUtil = new ForUtil();
        final ForDeltaUtil forDeltaUtil = new ForDeltaUtil();
        final PForUtil pforUtil = new PForUtil(this.forUtil);
        private final long[] docBuffer = new long[129];
        private final long[] freqBuffer = new long[128];
        private final long[] posDeltaBuffer = new long[128];
        private int docBufferUpto;
        private int posBufferUpto;
        final IndexInput startDocIn;
        final IndexInput docIn;
        final PostingDecodingUtil docInUtil;
        final IndexInput posIn;
        final PostingDecodingUtil posInUtil;
        final boolean indexHasFreq;
        final boolean indexHasPos;
        final boolean indexHasOffsets;
        final boolean indexHasPayloads;
        final boolean indexHasOffsetsOrPayloads;
        private int docFreq;
        private long totalTermFreq;
        private int docCountUpto;
        private int doc;
        private long prevDocID;
        private int freq;
        private int position;
        private long posPendingCount;
        private long posTermStartFP;
        private long lastPosBlockFP;
        private boolean needsRefilling;
        private int level0LastDocID;
        private long level0DocEndFP;
        private long level0PosEndFP;
        private int level0BlockPosUpto;
        private final BytesRefBuilder level0SerializedImpacts = new BytesRefBuilder();
        private final ByteArrayDataInput level0SerializedImpactsIn = new ByteArrayDataInput();
        private final MutableImpactList level0Impacts;
        private int level1LastDocID;
        private long level1DocEndFP;
        private int level1DocCountUpto;
        private long level1PosEndFP;
        private int level1BlockPosUpto;
        private final BytesRefBuilder level1SerializedImpacts = new BytesRefBuilder();
        private final ByteArrayDataInput level1SerializedImpactsIn = new ByteArrayDataInput();
        private final MutableImpactList level1Impacts;
        private int singletonDocID;

        public BlockImpactsPostingsEnum(FieldInfo fieldInfo, Lucene912PostingsFormat.IntBlockTermState termState) throws IOException {
            this.startDocIn = Lucene912PostingsReader.this.docIn;
            this.indexHasFreq = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
            this.indexHasPos = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            this.indexHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            this.indexHasPayloads = fieldInfo.hasPayloads();
            this.indexHasOffsetsOrPayloads = this.indexHasOffsets || this.indexHasPayloads;
            this.posIn = Lucene912PostingsReader.this.posIn.clone();
            this.posInUtil = VECTORIZATION_PROVIDER.newPostingDecodingUtil(this.posIn);
            this.docBuffer[128] = Integer.MAX_VALUE;
            this.docFreq = termState.docFreq;
            this.posTermStartFP = termState.posStartFP;
            this.totalTermFreq = termState.totalTermFreq;
            this.singletonDocID = termState.singletonDocID;
            if (this.docFreq > 1) {
                this.docIn = this.startDocIn.clone();
                this.docInUtil = VECTORIZATION_PROVIDER.newPostingDecodingUtil(this.docIn);
            } else {
                this.docIn = null;
                this.docInUtil = null;
            }
            this.posIn.seek(this.posTermStartFP);
            this.level1PosEndFP = this.posTermStartFP;
            this.level0PosEndFP = this.posTermStartFP;
            this.posPendingCount = 0L;
            this.lastPosBlockFP = termState.totalTermFreq < 128L ? this.posTermStartFP : (termState.totalTermFreq == 128L ? -1L : this.posTermStartFP + termState.lastPosBlockOffset);
            this.doc = -1;
            this.prevDocID = -1L;
            this.docCountUpto = 0;
            this.level0LastDocID = -1;
            if (this.docFreq < 4096) {
                this.level1LastDocID = Integer.MAX_VALUE;
                if (this.docFreq > 1) {
                    this.docIn.seek(termState.docStartFP);
                }
            } else {
                this.level1LastDocID = -1;
                this.level1DocEndFP = termState.docStartFP;
            }
            this.level1DocCountUpto = 0;
            this.level1BlockPosUpto = 0;
            this.docBufferUpto = 128;
            this.posBufferUpto = 128;
            this.level0SerializedImpacts.growNoCopy(Lucene912PostingsReader.this.maxImpactNumBytesAtLevel0);
            this.level1SerializedImpacts.growNoCopy(Lucene912PostingsReader.this.maxImpactNumBytesAtLevel1);
            this.level0Impacts = new MutableImpactList(Lucene912PostingsReader.this.maxNumImpactsAtLevel0);
            this.level1Impacts = new MutableImpactList(Lucene912PostingsReader.this.maxNumImpactsAtLevel1);
        }

        @Override
        public int freq() throws IOException {
            return this.freq;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        private void refillDocs() throws IOException {
            int left = this.docFreq - this.docCountUpto;
            assert (left >= 0);
            if (left >= 128) {
                this.forDeltaUtil.decodeAndPrefixSum(this.docInUtil, this.prevDocID, this.docBuffer);
                this.pforUtil.decode(this.docInUtil, this.freqBuffer);
                this.docCountUpto += 128;
            } else if (this.docFreq == 1) {
                this.docBuffer[0] = this.singletonDocID;
                this.freqBuffer[0] = this.totalTermFreq;
                this.docBuffer[1] = Integer.MAX_VALUE;
                ++this.docCountUpto;
            } else {
                PostingsUtil.readVIntBlock(this.docIn, this.docBuffer, this.freqBuffer, left, this.indexHasFreq, true);
                Lucene912PostingsReader.prefixSum(this.docBuffer, left, this.prevDocID);
                this.docBuffer[left] = Integer.MAX_VALUE;
                this.docCountUpto += left;
            }
            this.prevDocID = this.docBuffer[127];
            this.docBufferUpto = 0;
            assert (this.docBuffer[128] == Integer.MAX_VALUE);
        }

        private void skipLevel1To(int target) throws IOException {
            block5: {
                long skip1EndFP;
                do {
                    this.prevDocID = this.level1LastDocID;
                    this.level0LastDocID = this.level1LastDocID;
                    this.docIn.seek(this.level1DocEndFP);
                    this.level0PosEndFP = this.level1PosEndFP;
                    this.level0BlockPosUpto = this.level1BlockPosUpto;
                    this.docCountUpto = this.level1DocCountUpto;
                    this.level1DocCountUpto += 4096;
                    if (this.docFreq - this.docCountUpto < 4096) {
                        this.level1LastDocID = Integer.MAX_VALUE;
                        break block5;
                    }
                    this.level1LastDocID += this.docIn.readVInt();
                    this.level1DocEndFP = this.docIn.readVLong() + this.docIn.getFilePointer();
                    skip1EndFP = (long)this.docIn.readShort() + this.docIn.getFilePointer();
                    short numImpactBytes = this.docIn.readShort();
                    if (this.level1LastDocID >= target) {
                        this.docIn.readBytes(this.level1SerializedImpacts.bytes(), 0, numImpactBytes);
                        this.level1SerializedImpacts.setLength(numImpactBytes);
                    } else {
                        this.docIn.skipBytes(numImpactBytes);
                    }
                    this.level1PosEndFP += this.docIn.readVLong();
                    this.level1BlockPosUpto = this.docIn.readByte();
                    assert (this.indexHasOffsetsOrPayloads || this.docIn.getFilePointer() == skip1EndFP);
                } while (this.level1LastDocID < target);
                this.docIn.seek(skip1EndFP);
            }
        }

        private void skipLevel0To(int target) throws IOException {
            block5: {
                while (true) {
                    this.prevDocID = this.level0LastDocID;
                    if (this.level0PosEndFP >= this.posIn.getFilePointer()) {
                        this.posIn.seek(this.level0PosEndFP);
                        this.posPendingCount = this.level0BlockPosUpto;
                        this.posBufferUpto = 128;
                    } else {
                        for (int i = this.docBufferUpto; i < 128; ++i) {
                            this.posPendingCount += this.freqBuffer[i];
                        }
                    }
                    if (this.docFreq - this.docCountUpto < 128) break;
                    this.docIn.readVLong();
                    int docDelta = Lucene912PostingsReader.readVInt15(this.docIn);
                    long blockLength = Lucene912PostingsReader.readVLong15(this.docIn);
                    this.level0DocEndFP = this.docIn.getFilePointer() + blockLength;
                    this.level0LastDocID += docDelta;
                    if (target <= this.level0LastDocID) {
                        int numImpactBytes = this.docIn.readVInt();
                        this.docIn.readBytes(this.level0SerializedImpacts.bytes(), 0, numImpactBytes);
                        this.level0SerializedImpacts.setLength(numImpactBytes);
                        this.level0PosEndFP += this.docIn.readVLong();
                        this.level0BlockPosUpto = this.docIn.readByte();
                        if (!this.indexHasOffsetsOrPayloads) break block5;
                        this.docIn.readVLong();
                        this.docIn.readVInt();
                        break block5;
                    }
                    this.docIn.skipBytes(this.docIn.readVLong());
                    this.level0PosEndFP += this.docIn.readVLong();
                    this.level0BlockPosUpto = this.docIn.readVInt();
                    this.docIn.seek(this.level0DocEndFP);
                    this.docCountUpto += 128;
                }
                this.level0LastDocID = Integer.MAX_VALUE;
            }
        }

        @Override
        public void advanceShallow(int target) throws IOException {
            if (target > this.level0LastDocID) {
                if (target > this.level1LastDocID) {
                    this.skipLevel1To(target);
                } else if (this.needsRefilling) {
                    this.docIn.seek(this.level0DocEndFP);
                    this.docCountUpto += 128;
                }
                this.skipLevel0To(target);
                this.needsRefilling = true;
            }
        }

        @Override
        public Impacts getImpacts() throws IOException {
            return new Impacts(){

                @Override
                public int numLevels() {
                    int numLevels = 0;
                    if (BlockImpactsPostingsEnum.this.level0LastDocID != Integer.MAX_VALUE) {
                        ++numLevels;
                    }
                    if (BlockImpactsPostingsEnum.this.level1LastDocID != Integer.MAX_VALUE) {
                        ++numLevels;
                    }
                    if (numLevels == 0) {
                        ++numLevels;
                    }
                    return numLevels;
                }

                @Override
                public int getDocIdUpTo(int level) {
                    if (BlockImpactsPostingsEnum.this.level0LastDocID != Integer.MAX_VALUE) {
                        if (level == 0) {
                            return BlockImpactsPostingsEnum.this.level0LastDocID;
                        }
                        --level;
                    }
                    if (BlockImpactsPostingsEnum.this.level1LastDocID != Integer.MAX_VALUE) {
                        if (level == 0) {
                            return BlockImpactsPostingsEnum.this.level1LastDocID;
                        }
                        --level;
                    }
                    return Integer.MAX_VALUE;
                }

                @Override
                public List<Impact> getImpacts(int level) {
                    if (BlockImpactsPostingsEnum.this.level0LastDocID != Integer.MAX_VALUE) {
                        if (level == 0) {
                            BlockImpactsPostingsEnum.this.level0SerializedImpactsIn.reset(BlockImpactsPostingsEnum.this.level0SerializedImpacts.bytes(), 0, BlockImpactsPostingsEnum.this.level0SerializedImpacts.length());
                            Lucene912PostingsReader.readImpacts(BlockImpactsPostingsEnum.this.level0SerializedImpactsIn, BlockImpactsPostingsEnum.this.level0Impacts);
                            return BlockImpactsPostingsEnum.this.level0Impacts;
                        }
                        --level;
                    }
                    if (BlockImpactsPostingsEnum.this.level1LastDocID != Integer.MAX_VALUE) {
                        if (level == 0) {
                            BlockImpactsPostingsEnum.this.level1SerializedImpactsIn.reset(BlockImpactsPostingsEnum.this.level1SerializedImpacts.bytes(), 0, BlockImpactsPostingsEnum.this.level1SerializedImpacts.length());
                            Lucene912PostingsReader.readImpacts(BlockImpactsPostingsEnum.this.level1SerializedImpactsIn, BlockImpactsPostingsEnum.this.level1Impacts);
                            return BlockImpactsPostingsEnum.this.level1Impacts;
                        }
                        --level;
                    }
                    return Collections.singletonList(new Impact(Integer.MAX_VALUE, 1L));
                }
            };
        }

        @Override
        public int nextDoc() throws IOException {
            this.advanceShallow(this.doc + 1);
            if (this.needsRefilling) {
                this.refillDocs();
                this.needsRefilling = false;
            }
            this.doc = (int)this.docBuffer[this.docBufferUpto];
            this.freq = (int)this.freqBuffer[this.docBufferUpto];
            this.posPendingCount += (long)this.freq;
            ++this.docBufferUpto;
            this.position = 0;
            return this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            this.advanceShallow(target);
            if (this.needsRefilling) {
                this.refillDocs();
                this.needsRefilling = false;
            }
            int next = Lucene912PostingsReader.findFirstGreater(this.docBuffer, target, this.docBufferUpto);
            for (int i = this.docBufferUpto; i <= next; ++i) {
                this.posPendingCount += this.freqBuffer[i];
            }
            this.freq = (int)this.freqBuffer[next];
            this.docBufferUpto = next + 1;
            this.position = 0;
            this.doc = (int)this.docBuffer[next];
            return this.doc;
        }

        private void skipPositions() throws IOException {
            long toSkip = this.posPendingCount - (long)this.freq;
            int leftInBlock = 128 - this.posBufferUpto;
            if (toSkip < (long)leftInBlock) {
                this.posBufferUpto = (int)((long)this.posBufferUpto + toSkip);
            } else {
                toSkip -= (long)leftInBlock;
                while (toSkip >= 128L) {
                    assert (this.posIn.getFilePointer() != this.lastPosBlockFP);
                    this.pforUtil.skip(this.posIn);
                    toSkip -= 128L;
                }
                this.refillPositions();
                this.posBufferUpto = (int)toSkip;
            }
            this.position = 0;
        }

        private void refillPositions() throws IOException {
            if (this.posIn.getFilePointer() == this.lastPosBlockFP) {
                int count = (int)(this.totalTermFreq % 128L);
                int payloadLength = 0;
                for (int i = 0; i < count; ++i) {
                    int deltaCode;
                    int code = this.posIn.readVInt();
                    if (this.indexHasPayloads) {
                        if ((code & 1) != 0) {
                            payloadLength = this.posIn.readVInt();
                        }
                        this.posDeltaBuffer[i] = code >>> 1;
                        if (payloadLength != 0) {
                            this.posIn.skipBytes(payloadLength);
                        }
                    } else {
                        this.posDeltaBuffer[i] = code;
                    }
                    if (!this.indexHasOffsets || ((deltaCode = this.posIn.readVInt()) & 1) == 0) continue;
                    this.posIn.readVInt();
                }
            } else {
                this.pforUtil.decode(this.posInUtil, this.posDeltaBuffer);
            }
        }

        @Override
        public int nextPosition() throws IOException {
            assert (this.posPendingCount > 0L);
            if (this.posPendingCount > (long)this.freq) {
                this.skipPositions();
                this.posPendingCount = this.freq;
            }
            if (this.posBufferUpto == 128) {
                this.refillPositions();
                this.posBufferUpto = 0;
            }
            this.position = (int)((long)this.position + this.posDeltaBuffer[this.posBufferUpto]);
            ++this.posBufferUpto;
            --this.posPendingCount;
            return this.position;
        }

        @Override
        public int startOffset() {
            return -1;
        }

        @Override
        public int endOffset() {
            return -1;
        }

        @Override
        public BytesRef getPayload() {
            return null;
        }

        @Override
        public long cost() {
            return this.docFreq;
        }
    }

    final class BlockImpactsDocsEnum
    extends ImpactsEnum {
        final ForUtil forUtil = new ForUtil();
        final ForDeltaUtil forDeltaUtil = new ForDeltaUtil();
        final PForUtil pforUtil = new PForUtil(this.forUtil);
        private final long[] docBuffer = new long[129];
        private final long[] freqBuffer = new long[128];
        private int docBufferUpto;
        final IndexInput startDocIn;
        final IndexInput docIn;
        final PostingDecodingUtil docInUtil;
        final boolean indexHasFreq;
        final boolean indexHasPos;
        final boolean indexHasOffsetsOrPayloads;
        private int docFreq;
        private int docCountUpto;
        private int doc;
        private long prevDocID;
        private long freqFP;
        private boolean needsRefilling;
        private int level0LastDocID;
        private long level0DocEndFP;
        private final BytesRef level0SerializedImpacts;
        private final ByteArrayDataInput level0SerializedImpactsIn = new ByteArrayDataInput();
        private final MutableImpactList level0Impacts;
        private int level1LastDocID;
        private long level1DocEndFP;
        private int level1DocCountUpto;
        private final BytesRef level1SerializedImpacts;
        private final ByteArrayDataInput level1SerializedImpactsIn = new ByteArrayDataInput();
        private final MutableImpactList level1Impacts;

        public BlockImpactsDocsEnum(FieldInfo fieldInfo, Lucene912PostingsFormat.IntBlockTermState termState) throws IOException {
            this.startDocIn = Lucene912PostingsReader.this.docIn;
            this.indexHasFreq = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
            this.indexHasPos = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            this.indexHasOffsetsOrPayloads = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0 || fieldInfo.hasPayloads();
            this.docBuffer[128] = Integer.MAX_VALUE;
            this.docFreq = termState.docFreq;
            if (this.docFreq > 1) {
                this.docIn = this.startDocIn.clone();
                this.docInUtil = VECTORIZATION_PROVIDER.newPostingDecodingUtil(this.docIn);
            } else {
                this.docIn = null;
                this.docInUtil = null;
            }
            this.doc = -1;
            if (!this.indexHasFreq) {
                Arrays.fill(this.freqBuffer, 0, Math.min(128, this.docFreq), 1L);
            }
            this.prevDocID = -1L;
            this.docCountUpto = 0;
            this.level0LastDocID = -1;
            if (this.docFreq < 4096) {
                this.level1LastDocID = Integer.MAX_VALUE;
                if (this.docFreq > 1) {
                    this.docIn.seek(termState.docStartFP);
                }
            } else {
                this.level1LastDocID = -1;
                this.level1DocEndFP = termState.docStartFP;
            }
            this.level1DocCountUpto = 0;
            this.docBufferUpto = 128;
            this.freqFP = -1L;
            this.level0SerializedImpacts = new BytesRef(Lucene912PostingsReader.this.maxImpactNumBytesAtLevel0);
            this.level1SerializedImpacts = new BytesRef(Lucene912PostingsReader.this.maxImpactNumBytesAtLevel1);
            this.level0Impacts = new MutableImpactList(Lucene912PostingsReader.this.maxNumImpactsAtLevel0);
            this.level1Impacts = new MutableImpactList(Lucene912PostingsReader.this.maxNumImpactsAtLevel1);
        }

        @Override
        public int freq() throws IOException {
            if (this.freqFP != -1L) {
                this.docIn.seek(this.freqFP);
                this.pforUtil.decode(this.docInUtil, this.freqBuffer);
                this.freqFP = -1L;
            }
            return (int)this.freqBuffer[this.docBufferUpto - 1];
        }

        @Override
        public int nextPosition() throws IOException {
            return -1;
        }

        @Override
        public int startOffset() throws IOException {
            return -1;
        }

        @Override
        public int endOffset() throws IOException {
            return -1;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return null;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        private void refillDocs() throws IOException {
            int left = this.docFreq - this.docCountUpto;
            assert (left >= 0);
            if (left >= 128) {
                this.forDeltaUtil.decodeAndPrefixSum(this.docInUtil, this.prevDocID, this.docBuffer);
                if (this.indexHasFreq) {
                    this.freqFP = this.docIn.getFilePointer();
                    this.pforUtil.skip(this.docIn);
                }
                this.docCountUpto += 128;
            } else {
                PostingsUtil.readVIntBlock(this.docIn, this.docBuffer, this.freqBuffer, left, this.indexHasFreq, true);
                Lucene912PostingsReader.prefixSum(this.docBuffer, left, this.prevDocID);
                this.docBuffer[left] = Integer.MAX_VALUE;
                this.freqFP = -1L;
                this.docCountUpto += left;
            }
            this.prevDocID = this.docBuffer[127];
            this.docBufferUpto = 0;
            assert (this.docBuffer[128] == Integer.MAX_VALUE);
        }

        private void skipLevel1To(int target) throws IOException {
            block3: {
                do {
                    this.prevDocID = this.level1LastDocID;
                    this.level0LastDocID = this.level1LastDocID;
                    this.docIn.seek(this.level1DocEndFP);
                    this.docCountUpto = this.level1DocCountUpto;
                    this.level1DocCountUpto += 4096;
                    if (this.docFreq - this.docCountUpto < 4096) {
                        this.level1LastDocID = Integer.MAX_VALUE;
                        break block3;
                    }
                    this.level1LastDocID += this.docIn.readVInt();
                    this.level1DocEndFP = this.docIn.readVLong() + this.docIn.getFilePointer();
                } while (this.level1LastDocID < target);
                long skip1EndFP = (long)this.docIn.readShort() + this.docIn.getFilePointer();
                short numImpactBytes = this.docIn.readShort();
                this.docIn.readBytes(this.level1SerializedImpacts.bytes, 0, numImpactBytes);
                this.level1SerializedImpacts.length = numImpactBytes;
                assert (this.indexHasPos || this.docIn.getFilePointer() == skip1EndFP);
                this.docIn.seek(skip1EndFP);
            }
        }

        private void skipLevel0To(int target) throws IOException {
            block2: {
                while (true) {
                    this.prevDocID = this.level0LastDocID;
                    if (this.docFreq - this.docCountUpto < 128) break;
                    long skip0NumBytes = this.docIn.readVLong();
                    long skip0End = this.docIn.getFilePointer() + skip0NumBytes;
                    int docDelta = Lucene912PostingsReader.readVInt15(this.docIn);
                    long blockLength = Lucene912PostingsReader.readVLong15(this.docIn);
                    this.level0LastDocID += docDelta;
                    if (target <= this.level0LastDocID) {
                        this.level0DocEndFP = this.docIn.getFilePointer() + blockLength;
                        int numImpactBytes = this.docIn.readVInt();
                        this.docIn.readBytes(this.level0SerializedImpacts.bytes, 0, numImpactBytes);
                        this.level0SerializedImpacts.length = numImpactBytes;
                        this.docIn.seek(skip0End);
                        break block2;
                    }
                    this.docIn.skipBytes(blockLength);
                    this.docCountUpto += 128;
                }
                this.level0LastDocID = Integer.MAX_VALUE;
            }
        }

        @Override
        public void advanceShallow(int target) throws IOException {
            if (target > this.level0LastDocID) {
                if (target > this.level1LastDocID) {
                    this.skipLevel1To(target);
                } else if (this.needsRefilling) {
                    this.docIn.seek(this.level0DocEndFP);
                    this.docCountUpto += 128;
                }
                this.skipLevel0To(target);
                this.needsRefilling = true;
            }
        }

        private void moveToNextLevel0Block() throws IOException {
            if (this.doc == this.level1LastDocID) {
                this.skipLevel1To(this.doc + 1);
            } else if (this.needsRefilling) {
                this.docIn.seek(this.level0DocEndFP);
                this.docCountUpto += 128;
            }
            this.prevDocID = this.level0LastDocID;
            if (this.docFreq - this.docCountUpto >= 128) {
                long skip0Len = this.docIn.readVLong();
                long skip0End = this.docIn.getFilePointer() + skip0Len;
                int docDelta = Lucene912PostingsReader.readVInt15(this.docIn);
                long blockLength = Lucene912PostingsReader.readVLong15(this.docIn);
                this.level0LastDocID += docDelta;
                this.level0DocEndFP = this.docIn.getFilePointer() + blockLength;
                int numImpactBytes = this.docIn.readVInt();
                this.docIn.readBytes(this.level0SerializedImpacts.bytes, 0, numImpactBytes);
                this.level0SerializedImpacts.length = numImpactBytes;
                this.docIn.seek(skip0End);
            } else {
                this.level0LastDocID = Integer.MAX_VALUE;
            }
            this.refillDocs();
            this.needsRefilling = false;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.doc == this.level0LastDocID) {
                this.moveToNextLevel0Block();
            } else if (this.needsRefilling) {
                this.refillDocs();
                this.needsRefilling = false;
            }
            this.doc = (int)this.docBuffer[this.docBufferUpto++];
            return this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            if (target > this.level0LastDocID || this.needsRefilling) {
                this.advanceShallow(target);
                this.refillDocs();
                this.needsRefilling = false;
            }
            int next = Lucene912PostingsReader.findFirstGreater(this.docBuffer, target, this.docBufferUpto);
            this.doc = (int)this.docBuffer[next];
            this.docBufferUpto = next + 1;
            return this.doc;
        }

        @Override
        public Impacts getImpacts() throws IOException {
            return new Impacts(){

                @Override
                public int numLevels() {
                    int numLevels = 0;
                    if (BlockImpactsDocsEnum.this.level0LastDocID != Integer.MAX_VALUE) {
                        ++numLevels;
                    }
                    if (BlockImpactsDocsEnum.this.level1LastDocID != Integer.MAX_VALUE) {
                        ++numLevels;
                    }
                    if (numLevels == 0) {
                        ++numLevels;
                    }
                    return numLevels;
                }

                @Override
                public int getDocIdUpTo(int level) {
                    if (BlockImpactsDocsEnum.this.level0LastDocID != Integer.MAX_VALUE) {
                        if (level == 0) {
                            return BlockImpactsDocsEnum.this.level0LastDocID;
                        }
                        --level;
                    }
                    if (BlockImpactsDocsEnum.this.level1LastDocID != Integer.MAX_VALUE) {
                        if (level == 0) {
                            return BlockImpactsDocsEnum.this.level1LastDocID;
                        }
                        --level;
                    }
                    return Integer.MAX_VALUE;
                }

                @Override
                public List<Impact> getImpacts(int level) {
                    if (BlockImpactsDocsEnum.this.level0LastDocID != Integer.MAX_VALUE) {
                        if (level == 0) {
                            BlockImpactsDocsEnum.this.level0SerializedImpactsIn.reset(BlockImpactsDocsEnum.this.level0SerializedImpacts.bytes, 0, BlockImpactsDocsEnum.this.level0SerializedImpacts.length);
                            Lucene912PostingsReader.readImpacts(BlockImpactsDocsEnum.this.level0SerializedImpactsIn, BlockImpactsDocsEnum.this.level0Impacts);
                            return BlockImpactsDocsEnum.this.level0Impacts;
                        }
                        --level;
                    }
                    if (BlockImpactsDocsEnum.this.level1LastDocID != Integer.MAX_VALUE) {
                        if (level == 0) {
                            BlockImpactsDocsEnum.this.level1SerializedImpactsIn.reset(BlockImpactsDocsEnum.this.level1SerializedImpacts.bytes, 0, BlockImpactsDocsEnum.this.level1SerializedImpacts.length);
                            Lucene912PostingsReader.readImpacts(BlockImpactsDocsEnum.this.level1SerializedImpactsIn, BlockImpactsDocsEnum.this.level1Impacts);
                            return BlockImpactsDocsEnum.this.level1Impacts;
                        }
                        --level;
                    }
                    return Collections.singletonList(new Impact(Integer.MAX_VALUE, 1L));
                }
            };
        }

        @Override
        public long cost() {
            return this.docFreq;
        }
    }

    final class EverythingEnum
    extends PostingsEnum {
        final ForUtil forUtil = new ForUtil();
        final ForDeltaUtil forDeltaUtil = new ForDeltaUtil();
        final PForUtil pforUtil = new PForUtil(this.forUtil);
        private final long[] docBuffer = new long[129];
        private final long[] freqBuffer = new long[129];
        private final long[] posDeltaBuffer = new long[128];
        private final long[] payloadLengthBuffer;
        private final long[] offsetStartDeltaBuffer;
        private final long[] offsetLengthBuffer;
        private byte[] payloadBytes;
        private int payloadByteUpto;
        private int payloadLength;
        private int lastStartOffset;
        private int startOffset;
        private int endOffset;
        private int docBufferUpto;
        private int posBufferUpto;
        final IndexInput startDocIn;
        IndexInput docIn;
        PostingDecodingUtil docInUtil;
        final IndexInput posIn;
        final PostingDecodingUtil posInUtil;
        final IndexInput payIn;
        final PostingDecodingUtil payInUtil;
        final BytesRef payload;
        final boolean indexHasFreq;
        final boolean indexHasPos;
        final boolean indexHasOffsets;
        final boolean indexHasPayloads;
        final boolean indexHasOffsetsOrPayloads;
        private int docFreq;
        private long totalTermFreq;
        private int docCountUpto;
        private int doc;
        private long prevDocID;
        private int freq;
        private int position;
        private long posPendingCount;
        private long posTermStartFP;
        private long payTermStartFP;
        private long lastPosBlockFP;
        private int level0LastDocID;
        private long level0PosEndFP;
        private int level0BlockPosUpto;
        private long level0PayEndFP;
        private int level0BlockPayUpto;
        private int level1LastDocID;
        private long level1DocEndFP;
        private int level1DocCountUpto;
        private long level1PosEndFP;
        private int level1BlockPosUpto;
        private long level1PayEndFP;
        private int level1BlockPayUpto;
        private boolean needsOffsets;
        private boolean needsPayloads;
        private int singletonDocID;

        public EverythingEnum(FieldInfo fieldInfo) throws IOException {
            this.startDocIn = Lucene912PostingsReader.this.docIn;
            this.docIn = null;
            this.indexHasFreq = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
            this.indexHasPos = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            this.indexHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            this.indexHasPayloads = fieldInfo.hasPayloads();
            this.indexHasOffsetsOrPayloads = this.indexHasOffsets || this.indexHasPayloads;
            this.posIn = Lucene912PostingsReader.this.posIn.clone();
            this.posInUtil = VECTORIZATION_PROVIDER.newPostingDecodingUtil(this.posIn);
            if (this.indexHasOffsetsOrPayloads) {
                this.payIn = Lucene912PostingsReader.this.payIn.clone();
                this.payInUtil = VECTORIZATION_PROVIDER.newPostingDecodingUtil(this.payIn);
            } else {
                this.payIn = null;
                this.payInUtil = null;
            }
            if (this.indexHasOffsets) {
                this.offsetStartDeltaBuffer = new long[128];
                this.offsetLengthBuffer = new long[128];
            } else {
                this.offsetStartDeltaBuffer = null;
                this.offsetLengthBuffer = null;
                this.startOffset = -1;
                this.endOffset = -1;
            }
            if (this.indexHasPayloads) {
                this.payloadLengthBuffer = new long[128];
                this.payloadBytes = new byte[128];
                this.payload = new BytesRef();
            } else {
                this.payloadLengthBuffer = null;
                this.payloadBytes = null;
                this.payload = null;
            }
            this.docBuffer[128] = Integer.MAX_VALUE;
        }

        public boolean canReuse(IndexInput docIn, FieldInfo fieldInfo) {
            return docIn == this.startDocIn && this.indexHasOffsets == fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0 && this.indexHasPayloads == fieldInfo.hasPayloads();
        }

        public PostingsEnum reset(Lucene912PostingsFormat.IntBlockTermState termState, int flags) throws IOException {
            this.docFreq = termState.docFreq;
            this.posTermStartFP = termState.posStartFP;
            this.payTermStartFP = termState.payStartFP;
            this.totalTermFreq = termState.totalTermFreq;
            this.singletonDocID = termState.singletonDocID;
            if (this.docFreq > 1 && this.docIn == null) {
                this.docIn = this.startDocIn.clone();
                this.docInUtil = VECTORIZATION_PROVIDER.newPostingDecodingUtil(this.docIn);
            }
            this.posIn.seek(this.posTermStartFP);
            if (this.indexHasOffsetsOrPayloads) {
                this.payIn.seek(this.payTermStartFP);
            }
            this.level1PosEndFP = this.posTermStartFP;
            this.level1PayEndFP = this.payTermStartFP;
            this.level0PosEndFP = this.posTermStartFP;
            this.level0PayEndFP = this.payTermStartFP;
            this.posPendingCount = 0L;
            this.payloadByteUpto = 0;
            this.lastPosBlockFP = termState.totalTermFreq < 128L ? this.posTermStartFP : (termState.totalTermFreq == 128L ? -1L : this.posTermStartFP + termState.lastPosBlockOffset);
            this.needsOffsets = PostingsEnum.featureRequested(flags, (short)56);
            this.needsPayloads = PostingsEnum.featureRequested(flags, (short)88);
            this.doc = -1;
            this.prevDocID = -1L;
            this.docCountUpto = 0;
            this.level0LastDocID = -1;
            if (this.docFreq < 4096) {
                this.level1LastDocID = Integer.MAX_VALUE;
                if (this.docFreq > 1) {
                    this.docIn.seek(termState.docStartFP);
                }
            } else {
                this.level1LastDocID = -1;
                this.level1DocEndFP = termState.docStartFP;
            }
            this.level1DocCountUpto = 0;
            this.level1BlockPosUpto = 0;
            this.level1BlockPayUpto = 0;
            this.level0BlockPosUpto = 0;
            this.level0BlockPayUpto = 0;
            this.docBufferUpto = 128;
            this.posBufferUpto = 128;
            return this;
        }

        @Override
        public int freq() throws IOException {
            return this.freq;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        private void refillDocs() throws IOException {
            int left = this.docFreq - this.docCountUpto;
            assert (left >= 0);
            if (left >= 128) {
                this.forDeltaUtil.decodeAndPrefixSum(this.docInUtil, this.prevDocID, this.docBuffer);
                this.pforUtil.decode(this.docInUtil, this.freqBuffer);
                this.docCountUpto += 128;
            } else if (this.docFreq == 1) {
                this.docBuffer[0] = this.singletonDocID;
                this.freqBuffer[0] = this.totalTermFreq;
                this.docBuffer[1] = Integer.MAX_VALUE;
                ++this.docCountUpto;
            } else {
                PostingsUtil.readVIntBlock(this.docIn, this.docBuffer, this.freqBuffer, left, this.indexHasFreq, true);
                Lucene912PostingsReader.prefixSum(this.docBuffer, left, this.prevDocID);
                this.docBuffer[left] = Integer.MAX_VALUE;
                this.docCountUpto += left;
            }
            this.prevDocID = this.docBuffer[127];
            this.docBufferUpto = 0;
            assert (this.docBuffer[128] == Integer.MAX_VALUE);
        }

        private void skipLevel1To(int target) throws IOException {
            do {
                this.prevDocID = this.level1LastDocID;
                this.level0LastDocID = this.level1LastDocID;
                this.docIn.seek(this.level1DocEndFP);
                this.level0PosEndFP = this.level1PosEndFP;
                this.level0BlockPosUpto = this.level1BlockPosUpto;
                if (this.indexHasOffsetsOrPayloads) {
                    this.level0PayEndFP = this.level1PayEndFP;
                    this.level0BlockPayUpto = this.level1BlockPayUpto;
                }
                this.docCountUpto = this.level1DocCountUpto;
                this.level1DocCountUpto += 4096;
                if (this.docFreq - this.docCountUpto < 4096) {
                    this.level1LastDocID = Integer.MAX_VALUE;
                    break;
                }
                this.level1LastDocID += this.docIn.readVInt();
                long delta = this.docIn.readVLong();
                this.level1DocEndFP = delta + this.docIn.getFilePointer();
                long skip1EndFP = (long)this.docIn.readShort() + this.docIn.getFilePointer();
                this.docIn.skipBytes(this.docIn.readShort());
                this.level1PosEndFP += this.docIn.readVLong();
                this.level1BlockPosUpto = this.docIn.readByte();
                if (this.indexHasOffsetsOrPayloads) {
                    this.level1PayEndFP += this.docIn.readVLong();
                    this.level1BlockPayUpto = this.docIn.readVInt();
                }
                assert (this.docIn.getFilePointer() == skip1EndFP);
            } while (this.level1LastDocID < target);
        }

        private void moveToNextLevel0Block() throws IOException {
            if (this.doc == this.level1LastDocID) {
                this.skipLevel1To(this.doc + 1);
            }
            this.prevDocID = this.level0LastDocID;
            assert (this.docBufferUpto == 128);
            if (this.level0PosEndFP >= this.posIn.getFilePointer()) {
                this.posIn.seek(this.level0PosEndFP);
                this.posPendingCount = this.level0BlockPosUpto;
                if (this.indexHasOffsetsOrPayloads) {
                    assert (this.level0PayEndFP >= this.payIn.getFilePointer());
                    this.payIn.seek(this.level0PayEndFP);
                    this.payloadByteUpto = this.level0BlockPayUpto;
                }
                this.posBufferUpto = 128;
            }
            if (this.docFreq - this.docCountUpto >= 128) {
                this.docIn.readVLong();
                int docDelta = Lucene912PostingsReader.readVInt15(this.docIn);
                this.level0LastDocID += docDelta;
                Lucene912PostingsReader.readVLong15(this.docIn);
                this.docIn.skipBytes(this.docIn.readVLong());
                this.level0PosEndFP += this.docIn.readVLong();
                this.level0BlockPosUpto = this.docIn.readByte();
                if (this.indexHasOffsetsOrPayloads) {
                    this.level0PayEndFP += this.docIn.readVLong();
                    this.level0BlockPayUpto = this.docIn.readVInt();
                }
            } else {
                this.level0LastDocID = Integer.MAX_VALUE;
            }
            this.refillDocs();
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.doc == this.level0LastDocID) {
                this.moveToNextLevel0Block();
            }
            this.doc = (int)this.docBuffer[this.docBufferUpto];
            this.freq = (int)this.freqBuffer[this.docBufferUpto];
            ++this.docBufferUpto;
            this.posPendingCount += (long)this.freq;
            this.position = 0;
            this.lastStartOffset = 0;
            return this.doc;
        }

        private void skipLevel0To(int target) throws IOException {
            block8: {
                while (true) {
                    this.prevDocID = this.level0LastDocID;
                    if (this.level0PosEndFP >= this.posIn.getFilePointer()) {
                        this.posIn.seek(this.level0PosEndFP);
                        this.posPendingCount = this.level0BlockPosUpto;
                        if (this.indexHasOffsetsOrPayloads) {
                            assert (this.level0PayEndFP >= this.payIn.getFilePointer());
                            this.payIn.seek(this.level0PayEndFP);
                            this.payloadByteUpto = this.level0BlockPayUpto;
                        }
                        this.posBufferUpto = 128;
                    } else {
                        for (int i = this.docBufferUpto; i < 128; ++i) {
                            this.posPendingCount += this.freqBuffer[i];
                        }
                    }
                    if (this.docFreq - this.docCountUpto < 128) break;
                    this.docIn.readVLong();
                    int docDelta = Lucene912PostingsReader.readVInt15(this.docIn);
                    this.level0LastDocID += docDelta;
                    long blockLength = Lucene912PostingsReader.readVLong15(this.docIn);
                    long blockEndFP = this.docIn.getFilePointer() + blockLength;
                    this.docIn.skipBytes(this.docIn.readVLong());
                    this.level0PosEndFP += this.docIn.readVLong();
                    this.level0BlockPosUpto = this.docIn.readByte();
                    if (this.indexHasOffsetsOrPayloads) {
                        this.level0PayEndFP += this.docIn.readVLong();
                        this.level0BlockPayUpto = this.docIn.readVInt();
                    }
                    if (target > this.level0LastDocID) {
                        this.docIn.seek(blockEndFP);
                        this.docCountUpto += 128;
                        continue;
                    }
                    break block8;
                    break;
                }
                this.level0LastDocID = Integer.MAX_VALUE;
            }
        }

        @Override
        public int advance(int target) throws IOException {
            if (target > this.level0LastDocID) {
                if (target > this.level1LastDocID) {
                    this.skipLevel1To(target);
                }
                this.skipLevel0To(target);
                this.refillDocs();
            }
            int next = Lucene912PostingsReader.findFirstGreater(this.docBuffer, target, this.docBufferUpto);
            for (int i = this.docBufferUpto; i <= next; ++i) {
                this.posPendingCount += this.freqBuffer[i];
            }
            this.freq = (int)this.freqBuffer[next];
            this.docBufferUpto = next + 1;
            this.position = 0;
            this.lastStartOffset = 0;
            this.doc = (int)this.docBuffer[next];
            return this.doc;
        }

        private void skipPositions() throws IOException {
            long toSkip = this.posPendingCount - (long)this.freq;
            int leftInBlock = 128 - this.posBufferUpto;
            if (toSkip < (long)leftInBlock) {
                int end = (int)((long)this.posBufferUpto + toSkip);
                if (this.indexHasPayloads) {
                    for (int i = this.posBufferUpto; i < end; ++i) {
                        this.payloadByteUpto = (int)((long)this.payloadByteUpto + this.payloadLengthBuffer[i]);
                    }
                }
                this.posBufferUpto = end;
            } else {
                toSkip -= (long)leftInBlock;
                while (toSkip >= 128L) {
                    assert (this.posIn.getFilePointer() != this.lastPosBlockFP);
                    this.pforUtil.skip(this.posIn);
                    if (this.indexHasPayloads) {
                        this.pforUtil.skip(this.payIn);
                        int numBytes = this.payIn.readVInt();
                        this.payIn.seek(this.payIn.getFilePointer() + (long)numBytes);
                    }
                    if (this.indexHasOffsets) {
                        this.pforUtil.skip(this.payIn);
                        this.pforUtil.skip(this.payIn);
                    }
                    toSkip -= 128L;
                }
                this.refillPositions();
                this.payloadByteUpto = 0;
                this.posBufferUpto = 0;
                int toSkipInt = (int)toSkip;
                if (this.indexHasPayloads) {
                    for (int i = 0; i < toSkipInt; ++i) {
                        this.payloadByteUpto = (int)((long)this.payloadByteUpto + this.payloadLengthBuffer[i]);
                    }
                }
                this.posBufferUpto = toSkipInt;
            }
            this.position = 0;
            this.lastStartOffset = 0;
        }

        private void refillPositions() throws IOException {
            if (this.posIn.getFilePointer() == this.lastPosBlockFP) {
                int count = (int)(this.totalTermFreq % 128L);
                int payloadLength = 0;
                int offsetLength = 0;
                this.payloadByteUpto = 0;
                for (int i = 0; i < count; ++i) {
                    int code = this.posIn.readVInt();
                    if (this.indexHasPayloads) {
                        if ((code & 1) != 0) {
                            payloadLength = this.posIn.readVInt();
                        }
                        this.payloadLengthBuffer[i] = payloadLength;
                        this.posDeltaBuffer[i] = code >>> 1;
                        if (payloadLength != 0) {
                            if (this.payloadByteUpto + payloadLength > this.payloadBytes.length) {
                                this.payloadBytes = ArrayUtil.grow(this.payloadBytes, this.payloadByteUpto + payloadLength);
                            }
                            this.posIn.readBytes(this.payloadBytes, this.payloadByteUpto, payloadLength);
                            this.payloadByteUpto += payloadLength;
                        }
                    } else {
                        this.posDeltaBuffer[i] = code;
                    }
                    if (!this.indexHasOffsets) continue;
                    int deltaCode = this.posIn.readVInt();
                    if ((deltaCode & 1) != 0) {
                        offsetLength = this.posIn.readVInt();
                    }
                    this.offsetStartDeltaBuffer[i] = deltaCode >>> 1;
                    this.offsetLengthBuffer[i] = offsetLength;
                }
                this.payloadByteUpto = 0;
            } else {
                this.pforUtil.decode(this.posInUtil, this.posDeltaBuffer);
                if (this.indexHasPayloads) {
                    if (this.needsPayloads) {
                        this.pforUtil.decode(this.payInUtil, this.payloadLengthBuffer);
                        int numBytes = this.payIn.readVInt();
                        if (numBytes > this.payloadBytes.length) {
                            this.payloadBytes = ArrayUtil.growNoCopy(this.payloadBytes, numBytes);
                        }
                        this.payIn.readBytes(this.payloadBytes, 0, numBytes);
                    } else {
                        this.pforUtil.skip(this.payIn);
                        int numBytes = this.payIn.readVInt();
                        this.payIn.seek(this.payIn.getFilePointer() + (long)numBytes);
                    }
                    this.payloadByteUpto = 0;
                }
                if (this.indexHasOffsets) {
                    if (this.needsOffsets) {
                        this.pforUtil.decode(this.payInUtil, this.offsetStartDeltaBuffer);
                        this.pforUtil.decode(this.payInUtil, this.offsetLengthBuffer);
                    } else {
                        this.pforUtil.skip(this.payIn);
                        this.pforUtil.skip(this.payIn);
                    }
                }
            }
        }

        @Override
        public int nextPosition() throws IOException {
            assert (this.posPendingCount > 0L);
            if (this.posPendingCount > (long)this.freq) {
                this.skipPositions();
                this.posPendingCount = this.freq;
            }
            if (this.posBufferUpto == 128) {
                this.refillPositions();
                this.posBufferUpto = 0;
            }
            this.position = (int)((long)this.position + this.posDeltaBuffer[this.posBufferUpto]);
            if (this.indexHasPayloads) {
                this.payloadLength = (int)this.payloadLengthBuffer[this.posBufferUpto];
                this.payload.bytes = this.payloadBytes;
                this.payload.offset = this.payloadByteUpto;
                this.payload.length = this.payloadLength;
                this.payloadByteUpto += this.payloadLength;
            }
            if (this.indexHasOffsets) {
                this.startOffset = this.lastStartOffset + (int)this.offsetStartDeltaBuffer[this.posBufferUpto];
                this.endOffset = this.startOffset + (int)this.offsetLengthBuffer[this.posBufferUpto];
                this.lastStartOffset = this.startOffset;
            }
            ++this.posBufferUpto;
            --this.posPendingCount;
            return this.position;
        }

        @Override
        public int startOffset() {
            return this.startOffset;
        }

        @Override
        public int endOffset() {
            return this.endOffset;
        }

        @Override
        public BytesRef getPayload() {
            if (this.payloadLength == 0) {
                return null;
            }
            return this.payload;
        }

        @Override
        public long cost() {
            return this.docFreq;
        }
    }

    final class BlockDocsEnum
    extends PostingsEnum {
        final ForUtil forUtil = new ForUtil();
        final ForDeltaUtil forDeltaUtil = new ForDeltaUtil();
        final PForUtil pforUtil = new PForUtil(this.forUtil);
        private final long[] docBuffer = new long[129];
        private final long[] freqBuffer = new long[128];
        private int docBufferUpto;
        final IndexInput startDocIn;
        IndexInput docIn;
        PostingDecodingUtil docInUtil;
        final boolean indexHasFreq;
        final boolean indexHasPos;
        final boolean indexHasOffsetsOrPayloads;
        private int docFreq;
        private long totalTermFreq;
        private int docCountUpto;
        private int doc;
        private long prevDocID;
        private int level0LastDocID;
        private int level1LastDocID;
        private long level1DocEndFP;
        private int level1DocCountUpto;
        private boolean needsFreq;
        private int singletonDocID;
        private long freqFP;

        public BlockDocsEnum(FieldInfo fieldInfo) throws IOException {
            this.startDocIn = Lucene912PostingsReader.this.docIn;
            this.docIn = null;
            this.indexHasFreq = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
            this.indexHasPos = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            this.indexHasOffsetsOrPayloads = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0 || fieldInfo.hasPayloads();
            this.docBuffer[128] = Integer.MAX_VALUE;
        }

        public boolean canReuse(IndexInput docIn, FieldInfo fieldInfo) {
            return docIn == this.startDocIn && this.indexHasFreq == fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0 && this.indexHasPos == fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 && this.indexHasOffsetsOrPayloads == (fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0 || fieldInfo.hasPayloads());
        }

        public PostingsEnum reset(Lucene912PostingsFormat.IntBlockTermState termState, int flags) throws IOException {
            this.docFreq = termState.docFreq;
            this.totalTermFreq = this.indexHasFreq ? termState.totalTermFreq : (long)this.docFreq;
            this.singletonDocID = termState.singletonDocID;
            if (this.docFreq > 1 && this.docIn == null) {
                this.docIn = this.startDocIn.clone();
                this.docInUtil = VECTORIZATION_PROVIDER.newPostingDecodingUtil(this.docIn);
            }
            this.doc = -1;
            this.needsFreq = PostingsEnum.featureRequested(flags, (short)8);
            if (!this.indexHasFreq || !this.needsFreq) {
                Arrays.fill(this.freqBuffer, 0, Math.min(128, this.docFreq), 1L);
            }
            this.prevDocID = -1L;
            this.docCountUpto = 0;
            this.level0LastDocID = -1;
            if (this.docFreq < 4096) {
                this.level1LastDocID = Integer.MAX_VALUE;
                if (this.docFreq > 1) {
                    this.docIn.seek(termState.docStartFP);
                }
            } else {
                this.level1LastDocID = -1;
                this.level1DocEndFP = termState.docStartFP;
            }
            this.level1DocCountUpto = 0;
            this.docBufferUpto = 128;
            this.freqFP = -1L;
            return this;
        }

        @Override
        public int freq() throws IOException {
            if (this.freqFP != -1L) {
                this.docIn.seek(this.freqFP);
                this.pforUtil.decode(this.docInUtil, this.freqBuffer);
                this.freqFP = -1L;
            }
            return (int)this.freqBuffer[this.docBufferUpto - 1];
        }

        @Override
        public int nextPosition() throws IOException {
            return -1;
        }

        @Override
        public int startOffset() throws IOException {
            return -1;
        }

        @Override
        public int endOffset() throws IOException {
            return -1;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return null;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        private void refillFullBlock() throws IOException {
            assert (this.docFreq - this.docCountUpto >= 128);
            this.forDeltaUtil.decodeAndPrefixSum(this.docInUtil, this.prevDocID, this.docBuffer);
            if (this.indexHasFreq) {
                if (this.needsFreq) {
                    this.freqFP = this.docIn.getFilePointer();
                }
                this.pforUtil.skip(this.docIn);
            }
            this.docCountUpto += 128;
            this.prevDocID = this.docBuffer[127];
            this.docBufferUpto = 0;
            assert (this.docBuffer[128] == Integer.MAX_VALUE);
        }

        private void refillRemainder() throws IOException {
            int left = this.docFreq - this.docCountUpto;
            assert (left >= 0);
            assert (left < 128);
            if (this.docFreq == 1) {
                this.docBuffer[0] = this.singletonDocID;
                this.freqBuffer[0] = this.totalTermFreq;
                this.docBuffer[1] = Integer.MAX_VALUE;
                ++this.docCountUpto;
            } else {
                PostingsUtil.readVIntBlock(this.docIn, this.docBuffer, this.freqBuffer, left, this.indexHasFreq, this.needsFreq);
                Lucene912PostingsReader.prefixSum(this.docBuffer, left, this.prevDocID);
                this.docBuffer[left] = Integer.MAX_VALUE;
                this.docCountUpto += left;
            }
            this.docBufferUpto = 0;
            this.freqFP = -1L;
        }

        private void skipLevel1To(int target) throws IOException {
            block2: {
                do {
                    this.prevDocID = this.level1LastDocID;
                    this.level0LastDocID = this.level1LastDocID;
                    this.docIn.seek(this.level1DocEndFP);
                    this.docCountUpto = this.level1DocCountUpto;
                    this.level1DocCountUpto += 4096;
                    if (this.docFreq - this.docCountUpto < 4096) {
                        this.level1LastDocID = Integer.MAX_VALUE;
                        break block2;
                    }
                    this.level1LastDocID += this.docIn.readVInt();
                    this.level1DocEndFP = this.docIn.readVLong() + this.docIn.getFilePointer();
                } while (this.level1LastDocID < target);
                if (!this.indexHasFreq) break block2;
                this.docIn.skipBytes(this.docIn.readShort());
            }
        }

        private void skipLevel0To(int target) throws IOException {
            block2: {
                while (true) {
                    this.prevDocID = this.level0LastDocID;
                    if (this.docFreq - this.docCountUpto < 128) break;
                    long skip0NumBytes = this.docIn.readVLong();
                    long skip0EndFP = this.docIn.getFilePointer() + skip0NumBytes;
                    int docDelta = Lucene912PostingsReader.readVInt15(this.docIn);
                    this.level0LastDocID += docDelta;
                    if (target <= this.level0LastDocID) {
                        this.docIn.seek(skip0EndFP);
                        break block2;
                    }
                    this.docIn.skipBytes(Lucene912PostingsReader.readVLong15(this.docIn));
                    this.docCountUpto += 128;
                }
                this.level0LastDocID = Integer.MAX_VALUE;
            }
        }

        private void moveToNextLevel0Block() throws IOException {
            if (this.doc == this.level1LastDocID) {
                this.skipLevel1To(this.doc + 1);
            }
            this.prevDocID = this.level0LastDocID;
            if (this.docFreq - this.docCountUpto >= 128) {
                this.docIn.skipBytes(this.docIn.readVLong());
                this.refillFullBlock();
                this.level0LastDocID = (int)this.docBuffer[127];
            } else {
                this.level0LastDocID = Integer.MAX_VALUE;
                this.refillRemainder();
            }
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.doc == this.level0LastDocID) {
                this.moveToNextLevel0Block();
            }
            this.doc = (int)this.docBuffer[this.docBufferUpto++];
            return this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            if (target > this.level0LastDocID) {
                if (target > this.level1LastDocID) {
                    this.skipLevel1To(target);
                }
                this.skipLevel0To(target);
                if (this.docFreq - this.docCountUpto >= 128) {
                    this.refillFullBlock();
                } else {
                    this.refillRemainder();
                }
            }
            int next = Lucene912PostingsReader.findFirstGreater(this.docBuffer, target, this.docBufferUpto);
            this.doc = (int)this.docBuffer[next];
            this.docBufferUpto = next + 1;
            return this.doc;
        }

        @Override
        public long cost() {
            return this.docFreq;
        }
    }
}

