/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution.run;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRemoteConnectionCreator;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;

public class MavenExtRemoteConnectionCreator
implements RemoteConnectionCreator {
    static final ExtensionPointName<MavenRemoteConnectionCreator> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.idea.maven.mavenRemoteConnectionCreator");
    private final JavaParameters myJavaParameters;
    private final MavenRunConfiguration myRunConfiguration;

    public MavenExtRemoteConnectionCreator(JavaParameters javaParameters, MavenRunConfiguration runConfiguration) {
        this.myJavaParameters = javaParameters;
        this.myRunConfiguration = runConfiguration;
    }

    @Nullable
    public RemoteConnection createRemoteConnection(ExecutionEnvironment environment) {
        for (MavenRemoteConnectionCreator creator : EP_NAME.getExtensionList()) {
            RemoteConnection connection = creator.createRemoteConnection(this.myJavaParameters, this.myRunConfiguration);
            if (connection == null) continue;
            return connection;
        }
        return null;
    }

    public boolean isPollConnection() {
        return true;
    }
}

