/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.memberInfo;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KtPsiClassWrapper;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0006\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0005\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0007\u001a\u0010\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\b\u00a8\u0006\u000f"}, d2={"lightElementForMemberInfo", "Lcom/intellij/psi/PsiMember;", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "toJavaMemberInfo", "Lcom/intellij/refactoring/util/classMembers/MemberInfo;", "Lcom/intellij/refactoring/classMembers/MemberInfoBase;", "toKotlinMemberInfo", "Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfo;", "qualifiedClassNameForRendering", "", "Lcom/intellij/psi/PsiNamedElement;", "getChildrenToAnalyze", "", "Lcom/intellij/psi/PsiElement;", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nKotlinMemberInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMemberInfo.kt\norg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfoKt\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,100:1\n23#2,2:101\n*S KotlinDebug\n*F\n+ 1 KotlinMemberInfo.kt\norg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfoKt\n*L\n49#1:101,2\n*E\n"})
public final class KotlinMemberInfoKt {
    @Nullable
    public static final PsiMember lightElementForMemberInfo(@Nullable KtNamedDeclaration declaration) {
        Object object;
        KtNamedDeclaration ktNamedDeclaration = declaration;
        if (ktNamedDeclaration instanceof KtNamedFunction) {
            object = (PsiMember)LightClassUtilsKt.getRepresentativeLightMethod((PsiElement)((PsiElement)declaration));
        } else if (ktNamedDeclaration instanceof KtProperty || ktNamedDeclaration instanceof KtParameter) {
            Object object2;
            block8: {
                Object v1;
                boolean $i$f$firstIsInstanceOrNull;
                Iterable $this$firstIsInstanceOrNull$iv;
                List it;
                block7: {
                    it = LightClassUtilsKt.toLightElements((KtElement)((KtElement)declaration));
                    boolean bl = false;
                    $this$firstIsInstanceOrNull$iv = it;
                    $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof PsiMethod)) continue;
                        v1 = element$iv;
                        break block7;
                    }
                    v1 = null;
                }
                if ((object2 = (PsiMethod)v1) == null) {
                    $this$firstIsInstanceOrNull$iv = it;
                    $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof PsiField)) continue;
                        object2 = element$iv;
                        break block8;
                    }
                    object2 = null;
                }
            }
            object = (PsiMember)object2;
        } else {
            object = ktNamedDeclaration instanceof KtClassOrObject ? (PsiMember)LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)declaration)) : (ktNamedDeclaration instanceof KtPsiClassWrapper ? (PsiMember)((KtPsiClassWrapper)declaration).getPsiClass() : null);
        }
        return object;
    }

    @Nullable
    public static final MemberInfo toJavaMemberInfo(@NotNull MemberInfoBase<? extends KtNamedDeclaration> $this$toJavaMemberInfo) {
        PsiMember psiMember;
        Intrinsics.checkNotNullParameter($this$toJavaMemberInfo, (String)"<this>");
        KtNamedDeclaration declaration = (KtNamedDeclaration)$this$toJavaMemberInfo.getMember();
        PsiMember psiMember2 = psiMember = KotlinMemberInfoKt.lightElementForMemberInfo(declaration);
        if (psiMember2 == null) {
            return null;
        }
        MemberInfo info2 = new MemberInfo(psiMember2, psiMember instanceof PsiClass && $this$toJavaMemberInfo.getOverrides() != null, null);
        info2.setToAbstract($this$toJavaMemberInfo.isToAbstract());
        info2.setChecked($this$toJavaMemberInfo.isChecked());
        return info2;
    }

    @Nullable
    public static final KotlinMemberInfo toKotlinMemberInfo(@NotNull MemberInfo $this$toKotlinMemberInfo) {
        KtNamedDeclaration declaration;
        KotlinMemberInfo kotlinMemberInfo;
        Intrinsics.checkNotNullParameter((Object)$this$toKotlinMemberInfo, (String)"<this>");
        PsiElement psiElement = $this$toKotlinMemberInfo.getMember();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getMember(...)");
        PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)psiElement);
        KtNamedDeclaration ktNamedDeclaration = psiElement2 instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement2 : null;
        if (ktNamedDeclaration == null) {
            return null;
        }
        KotlinMemberInfo $this$toKotlinMemberInfo_u24lambda_u241 = kotlinMemberInfo = new KotlinMemberInfo(declaration, (declaration = ktNamedDeclaration) instanceof KtClass && $this$toKotlinMemberInfo.getOverrides() != null, false, 4, null);
        boolean bl = false;
        $this$toKotlinMemberInfo_u24lambda_u241.setToAbstract($this$toKotlinMemberInfo.isToAbstract());
        return kotlinMemberInfo;
    }

    @NlsSafe
    @NotNull
    public static final String qualifiedClassNameForRendering(@NotNull PsiNamedElement $this$qualifiedClassNameForRendering) {
        String fqName2;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$qualifiedClassNameForRendering, (String)"<this>");
        PsiNamedElement psiNamedElement = $this$qualifiedClassNameForRendering;
        if (psiNamedElement instanceof KtClassOrObject) {
            FqName fqName3 = ((KtClassOrObject)$this$qualifiedClassNameForRendering).getFqName();
            string2 = fqName3 != null ? fqName3.asString() : null;
        } else if (psiNamedElement instanceof PsiClass) {
            string2 = ((PsiClass)$this$qualifiedClassNameForRendering).getQualifiedName();
        } else {
            throw new AssertionError((Object)("Not a class: " + PsiUtilsKt.getElementTextWithContext((PsiElement)((PsiElement)$this$qualifiedClassNameForRendering))));
        }
        if ((string = (fqName2 = string2)) == null && (string = $this$qualifiedClassNameForRendering.getName()) == null) {
            string = KotlinBundle.message((String)"text.anonymous", (Object[])new Object[0]);
        }
        return string;
    }

    @NotNull
    public static final List<PsiElement> getChildrenToAnalyze(@NotNull KotlinMemberInfo $this$getChildrenToAnalyze) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getChildrenToAnalyze), (String)"<this>");
        KtNamedDeclaration member = (KtNamedDeclaration)$this$getChildrenToAnalyze.getMember();
        Intrinsics.checkNotNull((Object)member);
        List childrenToCheck = SequencesKt.toMutableList((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)member))));
        if ($this$getChildrenToAnalyze.isToAbstract() && member instanceof KtCallableDeclaration) {
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)member;
            if (ktCallableDeclaration instanceof KtNamedFunction) {
                Collection collection = childrenToCheck;
                PsiElement psiElement = (PsiElement)((KtNamedFunction)member).getBodyExpression();
                TypeIntrinsics.asMutableCollection((Object)collection).remove(psiElement);
            } else if (ktCallableDeclaration instanceof KtProperty) {
                Collection collection = childrenToCheck;
                PsiElement psiElement = (PsiElement)((KtProperty)member).getInitializer();
                TypeIntrinsics.asMutableCollection((Object)collection).remove(psiElement);
                collection = childrenToCheck;
                psiElement = (PsiElement)((KtProperty)member).getDelegateExpression();
                TypeIntrinsics.asMutableCollection((Object)collection).remove(psiElement);
                List list2 = ((KtProperty)member).getAccessors();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAccessors(...)");
                childrenToCheck.removeAll(list2);
            }
        }
        return childrenToCheck;
    }
}

