/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.AddExclExclCallFix;
import org.jetbrains.kotlin.idea.quickfix.AddExclExclCallFixKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SmartCastImpossibleExclExclFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
public final class SmartCastImpossibleExclExclFixFactory
extends KotlinSingleIntentionActionFactory {
    @NotNull
    public static final SmartCastImpossibleExclExclFixFactory INSTANCE = new SmartCastImpossibleExclExclFixFactory();

    private SmartCastImpossibleExclExclFixFactory() {
    }

    @Override
    @Nullable
    protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        if (diagnostic.getFactory() != Errors.SMARTCAST_IMPOSSIBLE) {
            return null;
        }
        PsiElement psiElement = diagnostic.getPsiElement();
        KtExpression ktExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
        if (ktExpression == null) {
            return null;
        }
        KtExpression element = ktExpression;
        BindingContext analyze2 = ResolutionUtils.analyze((KtElement)element, BodyResolveMode.PARTIAL);
        KotlinType type2 = analyze2.getType(element);
        if (type2 == null || !TypeUtils.isNullableType((KotlinType)type2)) {
            return null;
        }
        DiagnosticWithParameters3 diagnosticWithParameters = (DiagnosticWithParameters3)Errors.SMARTCAST_IMPOSSIBLE.cast((UnboundDiagnostic)diagnostic);
        Object object = diagnosticWithParameters.getA();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-a>(...)");
        KotlinType expectedType = (KotlinType)object;
        if (TypeUtils.isNullableType((KotlinType)expectedType)) {
            return null;
        }
        KotlinType kotlinType = TypeUtils.makeNullable((KotlinType)expectedType);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"makeNullable(...)");
        KotlinType nullableExpectedType = kotlinType;
        if (!TypeUtilsKt.isSubtypeOf((KotlinType)type2, (KotlinType)nullableExpectedType)) {
            return null;
        }
        AddExclExclCallFix addExclExclCallFix = AddExclExclCallFixKt.getAddExclExclCallFix$default((PsiElement)element, false, 2, null);
        return addExclExclCallFix != null ? addExclExclCallFix.asIntention() : null;
    }
}

