/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.shellSupport.powershell;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.shellSupport.TerminalShLangService;
import org.jetbrains.plugins.terminal.block.shellSupport.powershell.PowerShellSupport$AliasDefinition$;
import org.jetbrains.plugins.terminal.exp.completion.TerminalShellSupport;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/terminal/block/shellSupport/powershell/PowerShellSupport;", "Lorg/jetbrains/plugins/terminal/exp/completion/TerminalShellSupport;", "<init>", "()V", "promptContentElementType", "Lcom/intellij/psi/tree/IElementType;", "getPromptContentElementType", "()Lcom/intellij/psi/tree/IElementType;", "lineContinuationChar", "", "getLineContinuationChar", "()C", "getCommandTokens", "", "", "project", "Lcom/intellij/openapi/project/Project;", "command", "parseCommandHistory", "history", "parseAliases", "", "aliasesDefinition", "AliasDefinition", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nPowerShellSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PowerShellSupport.kt\norg/jetbrains/plugins/terminal/block/shellSupport/powershell/PowerShellSupport\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,75:1\n48#2:76\n48#2:77\n222#3:78\n1193#4,2:79\n1267#4,4:81\n14#5:85\n*S KotlinDebug\n*F\n+ 1 PowerShellSupport.kt\norg/jetbrains/plugins/terminal/block/shellSupport/powershell/PowerShellSupport\n*L\n17#1:76\n22#1:77\n59#1:78\n65#1:79,2\n65#1:81,4\n72#1:85\n*E\n"})
public final class PowerShellSupport
implements TerminalShellSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final char lineContinuationChar = (char)96;
    @NotNull
    private static final Logger LOG;

    @Override
    @Nullable
    public IElementType getPromptContentElementType() {
        boolean $i$f$serviceOrNull = false;
        Application application = ApplicationManager.getApplication();
        TerminalShLangService terminalShLangService = (TerminalShLangService)(application != null ? application.getService(TerminalShLangService.class) : null);
        return terminalShLangService != null ? terminalShLangService.getPromptContentElementType() : null;
    }

    @Override
    public char getLineContinuationChar() {
        return this.lineContinuationChar;
    }

    @Override
    @Nullable
    public List<String> getCommandTokens(@NotNull Project project, @NotNull String command2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        boolean $i$f$serviceOrNull = false;
        Application application = ApplicationManager.getApplication();
        TerminalShLangService terminalShLangService = (TerminalShLangService)(application != null ? application.getService(TerminalShLangService.class) : null);
        return terminalShLangService != null ? terminalShLangService.getShellCommandTokens(project, command2) : null;
    }

    @Override
    @NotNull
    public List<String> parseCommandHistory(@NotNull String history) {
        Intrinsics.checkNotNullParameter((Object)history, (String)"history");
        String string = StringUtil.convertLineSeparators((String)history, (String)"\n");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        String trimmedHistory = ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
        if (StringsKt.isBlank((CharSequence)trimmedHistory)) {
            return CollectionsKt.emptyList();
        }
        String[] stringArray = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)trimmedHistory, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        List historyItems = new ArrayList();
        for (int ind = 0; ind < lines.size(); ++ind) {
            boolean bl;
            String line = (String)lines.get(ind);
            if (StringsKt.endsWith$default((String)line, (String)"`", (boolean)false, (int)2, null)) {
                StringBuilder builder = new StringBuilder(StringsKt.removeSuffix((String)line, (CharSequence)"`")).append("\n");
                ++ind;
                while (ind < lines.size() && StringsKt.endsWith$default((String)((String)lines.get(ind)), (String)"`", (boolean)false, (int)2, null)) {
                    builder.append(StringsKt.removeSuffix((String)((String)lines.get(ind)), (CharSequence)"`")).append("\n");
                    ++ind;
                }
                if (ind < lines.size()) {
                    builder.append((String)lines.get(ind));
                }
                String string2 = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                bl = historyItems.add(string2);
                continue;
            }
            bl = historyItems.add(line);
        }
        return historyItems;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, String> parseAliases(@NotNull String aliasesDefinition) {
        void $this$associateTo$iv$iv;
        List this_$iv;
        Intrinsics.checkNotNullParameter((Object)aliasesDefinition, (String)"aliasesDefinition");
        try {
            Json json = (Json)Json.Default;
            String string$iv = aliasesDefinition;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            this_$iv = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(AliasDefinition.Companion.serializer()), string$iv);
        }
        catch (Throwable t) {
            LOG.error("Failed to parse aliases: '" + aliasesDefinition + "'", t);
            this_$iv = CollectionsKt.emptyList();
        }
        List aliases = this_$iv;
        Iterable $this$associate$iv = aliases;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            AliasDefinition it = (AliasDefinition)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getDefinition());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PowerShellSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B/\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/terminal/block/shellSupport/powershell/PowerShellSupport$AliasDefinition;", "", "name", "", "definition", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getName", "()Ljava/lang/String;", "getDefinition", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_terminal", "$serializer", "Companion", "intellij.terminal"})
    private static final class AliasDefinition {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @NotNull
        private final String definition;

        public AliasDefinition(@NotNull String name, @NotNull String definition) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
            this.name = name;
            this.definition = definition;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDefinition() {
            return this.definition;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.definition;
        }

        @NotNull
        public final AliasDefinition copy(@NotNull String name, @NotNull String definition) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
            return new AliasDefinition(name, definition);
        }

        public static /* synthetic */ AliasDefinition copy$default(AliasDefinition aliasDefinition, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = aliasDefinition.name;
            }
            if ((n & 2) != 0) {
                string2 = aliasDefinition.definition;
            }
            return aliasDefinition.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "AliasDefinition(name=" + this.name + ", definition=" + this.definition + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.definition.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AliasDefinition)) {
                return false;
            }
            AliasDefinition aliasDefinition = (AliasDefinition)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)aliasDefinition.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.definition, (Object)aliasDefinition.definition);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_terminal(AliasDefinition self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.name);
            output.encodeStringElement(serialDesc, 1, self.definition);
        }

        public /* synthetic */ AliasDefinition(int seen0, String name, String definition, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)AliasDefinition$$serializer.INSTANCE.getDescriptor());
            }
            this.name = name;
            this.definition = definition;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/terminal/block/shellSupport/powershell/PowerShellSupport$AliasDefinition$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/plugins/terminal/block/shellSupport/powershell/PowerShellSupport$AliasDefinition;", "intellij.terminal"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<AliasDefinition> serializer() {
                return (KSerializer)AliasDefinition$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/terminal/block/shellSupport/powershell/PowerShellSupport$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

