#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-DIxwx1lfz5xFy6cqz3xukE
key:                  hOpenPGP-2.10.1-DIxwx1lfz5xFy6cqz3xukE
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  e6e897d2988944f34bed9479b3f8f828
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.6.6/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-DIxwx1lfz5xFy6cqz3xukE
depends:
    aeson-2.2.0.0-4qLATSA6nfj1RfgXH6DMKK
    asn1-encoding-0.9.6-DFd7WnxxyUhJe90PepzNNG
    attoparsec-0.14.4-FIfeiNzOKYm3sEc1QPF51Z base-4.18.2.1
    base16-bytestring-1.0.2.0-4dU46p0HYXn6d3pnzwPlcc
    bifunctors-5.6.2-LE9PMEstwzEJDghPsSArS0 binary-0.8.9.1
    binary-conduit-1.3.1-9zYo0aJiMpIzInN2G33Wh bytestring-0.11.5.3
    bz2-1.0.1.1-AXpCjFAg2h01Pn30Db6li
    conduit-1.3.6.1-4cc2yOSL2sy5iK6rZQd5vm
    conduit-extra-1.3.8-KyGJKsBlxeR6aLyGVSa94z containers-0.6.7
    crypto-cipher-types-0.0.9-KR6SDml7aC01N7sg8RBO5C
    crypton-1.0.4-DGMKyUhI3LiKWt7ay9qYrG
    errors-2.3.0-8KvdJXLiMsG5HOXB7Hm0fo
    hashable-1.4.7.0-LE3bCdm1Wgy6IgVYkRoAlQ
    incremental-parser-0.5.1-HKHsY5sx1aH2juM3hgkqP1
    ixset-typed-0.5.1.0-3ehwoQysp8HChhP4H7UKDI
    lens-5.3.3-Ag3JywAjDxJ2k98xBhf4hs
    memory-0.18.0-6zo36PbRecTK4fqbBnx0f5
    monad-loops-0.4.3-LG7facWXNYz9W52syv7lz8
    nettle-0.3.1.1-DuwdlQIRX7hBXjJiv7OWDZ
    network-uri-2.6.4.2-3U0FvLc2coZ6tqjF5PGDly
    openpgp-asciiarmor-0.1.2-JoSS82hzBei36ypzHKHRvq
    prettyprinter-1.7.1-4PNEjQDcFkU8z4wKR8XxHs
    resourcet-1.2.6-Dhf0zTJRCL3LnKPExtEFW6
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8 text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-8XUEctZKps57K6Zw5siYoh
    transformers-0.6.1.0 unliftio-core-0.2.1.0-6sOpIonHj8t5wIbPhWbPHY
    unordered-containers-0.2.20.1-I6eyTXb69D2BhxejMtPouo
    zlib-0.7.0.0-AoTprguvpA33AfeZgt1J6J

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

