import { jsx } from 'react/jsx-runtime';
import { useRef, useEffect, useCallback } from 'react';
import '../types.js';
import { formatSQL } from '../utils/formatSQL.js';
import { SQLEditor } from '../../SQLEditor/components/SQLEditor.js';
import '@grafana/ui';
import '@grafana/data';
import '../../SQLEditor/standardSql/language.js';
import '../../SQLEditor/standardSql/macros.js';

function QueryEditorRaw({ children, onChange, query, width, height, completionProvider }) {
  const queryRef = useRef(query);
  useEffect(() => {
    queryRef.current = query;
  }, [query]);
  const onRawQueryChange = useCallback(
    (rawSql, processQuery) => {
      const newQuery = {
        ...queryRef.current,
        rawQuery: true,
        rawSql
      };
      onChange(newQuery, processQuery);
    },
    [onChange]
  );
  return /* @__PURE__ */ jsx(
    SQLEditor,
    {
      width,
      height,
      query: query.rawSql,
      onChange: onRawQueryChange,
      language: { id: "sql", completionProvider, formatter: formatSQL },
      children
    }
  );
}

export { QueryEditorRaw };
//# sourceMappingURL=QueryEditorRaw.js.map
