import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '@grafana/ui';

function ConfigDescriptionLink(props) {
  const { description, suffix, feature } = props;
  const text = `Learn more about ${feature}`;
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsxs("span", { className: styles.container, children: [
    description,
    /* @__PURE__ */ jsx(
      "a",
      {
        "aria-label": text,
        href: `https://grafana.com/docs/grafana/next/datasources/${suffix}`,
        rel: "noreferrer",
        target: "_blank",
        children: text
      }
    )
  ] });
}
const getStyles = (theme) => {
  return {
    container: css({
      color: theme.colors.text.secondary,
      a: css({
        color: theme.colors.text.link,
        textDecoration: "underline",
        marginLeft: "5px",
        "&:hover": {
          textDecoration: "none"
        }
      })
    })
  };
};

export { ConfigDescriptionLink };
//# sourceMappingURL=ConfigDescriptionLink.js.map
