/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.internal.classpath.RuntimeApiInfo;
import org.gradle.configuration.ImportsReader;
import org.gradle.internal.UncheckedException;

public class DefaultImportsReader
implements ImportsReader {
    private final String[] importPackages;
    private final Map<String, List<String>> simpleNameToFQCN;

    public DefaultImportsReader(RuntimeApiInfo runtimeApiInfo) {
        try {
            this.importPackages = DefaultImportsReader.generateImportPackages(runtimeApiInfo.getDefaultImportsResource());
            this.simpleNameToFQCN = DefaultImportsReader.generateSimpleNameToFQCN(runtimeApiInfo.getApiMappingResource());
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public String[] getImportPackages() {
        return this.importPackages;
    }

    @Override
    public Map<String, List<String>> getSimpleNameToFullClassNamesMapping() {
        return this.simpleNameToFQCN;
    }

    private static String[] generateImportPackages(URL url) throws IOException {
        return (String[])Resources.asCharSource((URL)url, (Charset)StandardCharsets.UTF_8).readLines((LineProcessor)new LineProcessor<String[]>(){
            private final List<String> packages = new LinkedList<String>();

            public boolean processLine(String line) throws IOException {
                this.packages.add(line.substring(7, line.length() - 2));
                return true;
            }

            public String[] getResult() {
                return this.packages.toArray(new String[this.packages.size()]);
            }
        });
    }

    private static Map<String, List<String>> generateSimpleNameToFQCN(URL url) throws IOException {
        return (Map)Resources.asCharSource((URL)url, (Charset)StandardCharsets.UTF_8).readLines((LineProcessor)new LineProcessor<Map<String, List<String>>>(){
            private final ImmutableMap.Builder<String, List<String>> builder = ImmutableMap.builder();

            public boolean processLine(String line) throws IOException {
                boolean process;
                boolean bl = process = !StringUtils.isEmpty((CharSequence)line);
                if (process) {
                    String[] split = line.split(":");
                    if (split.length == 2) {
                        String simpleName = split[0];
                        List fqcns = Splitter.on((char)';').omitEmptyStrings().splitToList((CharSequence)split[1]);
                        this.builder.put((Object)simpleName, (Object)fqcns);
                    } else {
                        process = false;
                    }
                }
                return process;
            }

            public Map<String, List<String>> getResult() {
                return this.builder.build();
            }
        });
    }
}

