---
stage: Runtime
group: Organizations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: プロジェクトのトピック
description: プロジェクトの整理、サブスクライブ、表示。
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

トピックは、プロジェクトを整理して見つけやすくするために、プロジェクトに割り当てることができるラベルです。トピックは通常、プロジェクトのコンテンツまたは目的を説明する短い名前です。複数のプロジェクトにトピックを割り当てることができます。

たとえば、Pythonを使用し、ハッカソンコントリビュートを目的とするすべてのプロジェクトに、`python`と`hackathon`のトピックを作成して割り当てることができます。

プロジェクトに割り当てられたトピックは、**Project overview**（プロジェクトの概要）と、プロジェクト情報の説明の下にある[**プロジェクト**](working_with_projects.md#view-projects)リストに表示されます。

{{< alert type="note" >}}

プロジェクトへのアクセス権を持つユーザーのみが、そのプロジェクトに割り当てられたトピックを表示できますが、すべてのユーザー（認証されていないユーザーを含む）が、GitLabインスタンスで利用可能なトピックを表示できます。トピック名に機密情報を含めないでください。

{{< /alert >}}

## トピックを見る {#explore-topics}

プロジェクトのトピックを調査するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択します。
1. **検索**を選択します。
1. 左側のサイドバーで、**トピック**を選択します。**トピックを見る**ページには、すべてのプロジェクトのトピックのリストが表示されます。
1. オプション。名前でトピックを絞り込むには、検索ボックスに検索条件を入力します。
1. トピックに関連付けられているプロジェクトを表示するには、トピックを選択します。URL `https://gitlab.com/explore/projects/topics/<topic-name>`を使用して、トピックページにアクセスすることもできます。

## トピックの絞り込みと並べ替え {#filter-and-sort-topics}

プロジェクトのトピックページで、そのトピックを持つプロジェクトのリストを以下で絞り込むことができます:

- 名前
- 言語
- 表示レベル
- オーナー
- アーカイブされたプロジェクト

次の条件でプロジェクトをソートすることもできます:

- 日付
- 名前
- スターの数

- 名前でプロジェクトを絞り込むには、検索ボックスに検索条件を入力します。
- 他の条件でプロジェクトを並べ替えるには、ドロップダウンリストからオプションを選択します。

## トピックの購読 {#subscribe-to-a-topic}

トピックに新しいプロジェクトが追加されたときに通知を受けたい場合は、そのRSSフィードを使用できます。

これは、**トピックを見る**ページまたはトピックを含むプロジェクトから実行できます。

トピックにサブスクライブするには:

- **トピックを見る**ページから:

  1. 左側のサイドバーで、一番上のシェブロン({{< icon name="chevron-down" >}})を展開する。
  1. **検索**を選択します。
  1. **トピック**を選択します。
  1. 購読するトピックを選択します。
  1. 右上隅で、**新しいプロジェクトフィードを購読する**({{< icon name="rss" >}})を選択します。

- プロジェクトから作成する場合: 

  1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
  1. **Project overview**（プロジェクトの概要）ページの**トピック**リストから、購読するトピックを選択します。
  1. 右上隅で、**新しいプロジェクトフィードを購読する**({{< icon name="rss" >}})を選択します。

結果は、Atom形式のRSSフィードとして表示されます。結果のURLには、フィードトークンと、そのトピックを持つプロジェクトのリストが含まれています。このURLをフィードリーダーに追加できます。

## プロジェクトへのトピックの割り当て {#assign-topics-to-a-project}

前提要件: 

- プロジェクトのメンテナー以上のロールを持っている必要があります。

プロジェクトにトピックを割り当てるには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **一般**を選択します。
1. **命名、説明、トピック**を展開する。
1. **プロジェクトのトピック**テキストボックスで、トピックを検索します。入力すると、人気のあるトピックが候補として表示されます。
1. **変更を保存**を選択します。

## トピックの管理 {#administer-topics}

インスタンスの管理者は、[**管理者**エリアのトピックページ](../../administration/admin_area.md#administering-topics)から、すべてのプロジェクトのトピックを管理できます。
