﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ssm-quicksetup/SSMQuickSetupRequest.h>
#include <aws/ssm-quicksetup/SSMQuickSetup_EXPORTS.h>

#include <utility>

namespace Aws {
namespace SSMQuickSetup {
namespace Model {

/**
 */
class UpdateConfigurationManagerRequest : public SSMQuickSetupRequest {
 public:
  AWS_SSMQUICKSETUP_API UpdateConfigurationManagerRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateConfigurationManager"; }

  AWS_SSMQUICKSETUP_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>A description of the configuration manager.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  UpdateConfigurationManagerRequest& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the configuration manager.</p>
   */
  inline const Aws::String& GetManagerArn() const { return m_managerArn; }
  inline bool ManagerArnHasBeenSet() const { return m_managerArnHasBeenSet; }
  template <typename ManagerArnT = Aws::String>
  void SetManagerArn(ManagerArnT&& value) {
    m_managerArnHasBeenSet = true;
    m_managerArn = std::forward<ManagerArnT>(value);
  }
  template <typename ManagerArnT = Aws::String>
  UpdateConfigurationManagerRequest& WithManagerArn(ManagerArnT&& value) {
    SetManagerArn(std::forward<ManagerArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A name for the configuration manager.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateConfigurationManagerRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_description;

  Aws::String m_managerArn;

  Aws::String m_name;
  bool m_descriptionHasBeenSet = false;
  bool m_managerArnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSMQuickSetup
}  // namespace Aws
