/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.internal;

import java.util.Collections;
import java.util.List;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.SetOnce;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.index.IndexService;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.engine.Segment;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.search.internal.ReaderContext;
import org.opensearch.search.internal.ShardSearchContextId;

public class PitReaderContext
extends ReaderContext {
    private final SetOnce<String> pitId = new SetOnce();
    private final SetOnce<Long> creationTime = new SetOnce();
    private final ShardRouting shardRouting;
    private final List<Segment> segments;

    public PitReaderContext(ShardSearchContextId id, IndexService indexService, IndexShard indexShard, Engine.SearcherSupplier searcherSupplier, long keepAliveInMillis, boolean singleSession) {
        super(id, indexService, indexShard, searcherSupplier, keepAliveInMillis, singleSession);
        this.shardRouting = indexShard.routingEntry();
        this.segments = indexShard.segments(true);
    }

    public String getPitId() {
        return (String)this.pitId.get();
    }

    public void setPitId(String pitId) {
        this.pitId.set((Object)pitId);
    }

    public Releasable updatePitIdAndKeepAlive(long keepAliveInMillis, String pitId, long createTime) {
        this.getRefCounted().incRef();
        this.tryUpdateKeepAlive(keepAliveInMillis);
        this.setPitId(pitId);
        this.setCreationTime(createTime);
        return Releasables.releaseOnce(() -> {
            this.updateLastAccessTime();
            this.getRefCounted().decRef();
        });
    }

    public long getCreationTime() {
        return this.creationTime.get() == null ? 0L : (Long)this.creationTime.get();
    }

    public void setCreationTime(long creationTime) {
        this.creationTime.set((Object)creationTime);
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public List<Segment> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }
}

